/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jfree.util.LogContext;
import org.jfree.util.LogTarget;

public class Log {
    private int debuglevel = 100;
    private LogTarget[] logTargets;
    private HashMap logContexts = new HashMap();
    private static Log singleton;

    protected Log() {
        this.logTargets = new LogTarget[0];
    }

    public static synchronized Log getInstance() {
        if (singleton == null) {
            singleton = new Log();
        }
        return singleton;
    }

    protected static synchronized void defineLog(Log log) {
        singleton = log;
    }

    public int getDebuglevel() {
        return this.debuglevel;
    }

    protected void setDebuglevel(int n) {
        this.debuglevel = n;
    }

    public synchronized void addTarget(LogTarget logTarget) {
        if (logTarget == null) {
            throw new NullPointerException();
        }
        LogTarget[] logTargetArray = new LogTarget[this.logTargets.length + 1];
        System.arraycopy(this.logTargets, 0, logTargetArray, 0, this.logTargets.length);
        logTargetArray[this.logTargets.length] = logTarget;
        this.logTargets = logTargetArray;
    }

    public synchronized void removeTarget(LogTarget logTarget) {
        if (logTarget == null) {
            throw new NullPointerException();
        }
        ArrayList<LogTarget> arrayList = new ArrayList<LogTarget>();
        arrayList.addAll(Arrays.asList(this.logTargets));
        arrayList.remove(logTarget);
        LogTarget[] logTargetArray = new LogTarget[arrayList.size()];
        this.logTargets = arrayList.toArray(logTargetArray);
    }

    public LogTarget[] getTargets() {
        return (LogTarget[])this.logTargets.clone();
    }

    public synchronized void replaceTargets(LogTarget logTarget) {
        if (logTarget == null) {
            throw new NullPointerException();
        }
        this.logTargets = new LogTarget[]{logTarget};
    }

    public static void debug(Object object) {
        Log.log(3, object);
    }

    public static void debug(Object object, Exception exception) {
        Log.log(3, object, exception);
    }

    public static void info(Object object) {
        Log.log(2, object);
    }

    public static void info(Object object, Exception exception) {
        Log.log(2, object, exception);
    }

    public static void warn(Object object) {
        Log.log(1, object);
    }

    public static void warn(Object object, Exception exception) {
        Log.log(1, object, exception);
    }

    public static void error(Object object) {
        Log.log(0, object);
    }

    public static void error(Object object, Exception exception) {
        Log.log(0, object, exception);
    }

    protected void doLog(int n, Object object) {
        if (n > 3) {
            n = 3;
        }
        if (n <= this.debuglevel) {
            int n2 = 0;
            while (n2 < this.logTargets.length) {
                LogTarget logTarget = this.logTargets[n2];
                logTarget.log(n, object);
                ++n2;
            }
        }
    }

    public static void log(int n, Object object) {
        Log.getInstance().doLog(n, object);
    }

    public static void log(int n, Object object, Exception exception) {
        Log.getInstance().doLog(n, object, exception);
    }

    protected void doLog(int n, Object object, Exception exception) {
        if (n > 3) {
            n = 3;
        }
        if (n <= this.debuglevel) {
            int n2 = 0;
            while (n2 < this.logTargets.length) {
                LogTarget logTarget = this.logTargets[n2];
                logTarget.log(n, object, exception);
                ++n2;
            }
        }
    }

    public void init() {
    }

    public static boolean isDebugEnabled() {
        return Log.getInstance().getDebuglevel() >= 3;
    }

    public static boolean isInfoEnabled() {
        return Log.getInstance().getDebuglevel() >= 2;
    }

    public static boolean isWarningEnabled() {
        return Log.getInstance().getDebuglevel() >= 1;
    }

    public static boolean isErrorEnabled() {
        return Log.getInstance().getDebuglevel() >= 0;
    }

    public static LogContext createContext(Class clazz) {
        return Log.createContext(clazz.getName());
    }

    public static LogContext createContext(String string) {
        return Log.getInstance().internalCreateContext(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogContext internalCreateContext(String string) {
        Log log = this;
        synchronized (log) {
            LogContext logContext = (LogContext)this.logContexts.get(string);
            if (logContext == null) {
                logContext = new LogContext(string);
                this.logContexts.put(string, logContext);
            }
            return logContext;
        }
    }

    public static class SimpleMessage {
        private String message;
        private Object[] param;

        public SimpleMessage(String string, Object object) {
            this.message = string;
            this.param = new Object[]{object};
        }

        public SimpleMessage(String string, Object object, Object object2) {
            this.message = string;
            this.param = new Object[]{object, object2};
        }

        public SimpleMessage(String string, Object object, Object object2, Object object3) {
            this.message = string;
            this.param = new Object[]{object, object2, object3};
        }

        public SimpleMessage(String string, Object object, Object object2, Object object3, Object object4) {
            this.message = string;
            this.param = new Object[]{object, object2, object3, object4};
        }

        public SimpleMessage(String string, Object[] objectArray) {
            this.message = string;
            this.param = objectArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.message);
            if (this.param != null) {
                int n = 0;
                while (n < this.param.length) {
                    stringBuffer.append(this.param[n]);
                    ++n;
                }
            }
            return stringBuffer.toString();
        }
    }
}

