/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.ObjectUtilities;

public class XYSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
Serializable {
    private static final long serialVersionUID = -7590013825931496766L;
    private List data = new ArrayList();
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this, false);

    public XYSeriesCollection() {
        this(null);
    }

    public XYSeriesCollection(XYSeries xYSeries) {
        this.addChangeListener(this.intervalDelegate);
        if (xYSeries != null) {
            this.data.add(xYSeries);
            xYSeries.addChangeListener(this);
        }
    }

    public void addSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(xYSeries);
        xYSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        xYSeries.removeChangeListener(this);
        this.data.remove(n);
        this.fireDatasetChanged();
    }

    public void removeSeries(XYSeries xYSeries) {
        if (xYSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            this.data.remove(xYSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        int n = 0;
        while (n < this.data.size()) {
            XYSeries xYSeries = (XYSeries)this.data.get(n);
            xYSeries.removeChangeListener(this);
            ++n;
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public XYSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XYSeries)this.data.get(n);
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getX(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getX();
    }

    public Number getStartX(int n, int n2) {
        return this.intervalDelegate.getStartX(n, n2);
    }

    public Number getEndX(int n, int n2) {
        return this.intervalDelegate.getEndX(n, n2);
    }

    public Number getY(int n, int n2) {
        XYSeries xYSeries = (XYSeries)this.data.get(n);
        XYDataItem xYDataItem = xYSeries.getDataItem(n2);
        return xYDataItem.getY();
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSeriesCollection)) {
            return false;
        }
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)object;
        return ObjectUtilities.equal(this.data, xYSeriesCollection.data);
    }

    public Object clone() throws CloneNotSupportedException {
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)super.clone();
        xYSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        xYSeriesCollection.intervalDelegate = (IntervalXYDelegate)this.intervalDelegate.clone();
        return xYSeriesCollection;
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    public double getDomainLowerBound(boolean bl) {
        return this.intervalDelegate.getDomainLowerBound(bl);
    }

    public double getDomainUpperBound(boolean bl) {
        return this.intervalDelegate.getDomainUpperBound(bl);
    }

    public Range getDomainBounds(boolean bl) {
        if (bl) {
            return this.intervalDelegate.getDomainBounds(bl);
        }
        return DatasetUtilities.iterateDomainBounds(this, bl);
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'width' argument.");
        }
        this.intervalDelegate.setFixedIntervalWidth(d);
        this.fireDatasetChanged();
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d) {
        this.intervalDelegate.setIntervalPositionFactor(d);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean bl) {
        this.intervalDelegate.setAutoWidth(bl);
        this.fireDatasetChanged();
    }
}

