/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import org.apache.commons.collections.ArrayStack;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class CallParamRule
extends Rule {
    protected String attributeName = null;
    protected int paramIndex = 0;
    protected boolean fromStack = false;
    protected int stackIndex = 0;
    protected ArrayStack bodyTextStack;

    public CallParamRule(Digester digester, int n) {
        this(n);
    }

    public CallParamRule(Digester digester, int n, String string) {
        this(n, string);
    }

    public CallParamRule(int n) {
        this(n, null);
    }

    public CallParamRule(int n, String string) {
        this.paramIndex = n;
        this.attributeName = string;
    }

    public CallParamRule(int n, boolean bl) {
        this.paramIndex = n;
        this.fromStack = bl;
    }

    public CallParamRule(int n, int n2) {
        this.paramIndex = n;
        this.fromStack = true;
        this.stackIndex = n2;
    }

    public void begin(Attributes attributes) throws Exception {
        Object object;
        Object object2 = null;
        if (this.attributeName != null) {
            object2 = attributes.getValue(this.attributeName);
        } else if (this.fromStack) {
            object2 = this.digester.peek(this.stackIndex);
            if (this.digester.log.isDebugEnabled()) {
                object = new StringBuffer("[CallParamRule]{");
                ((StringBuffer)object).append(this.digester.match);
                ((StringBuffer)object).append("} Save from stack; from stack?").append(this.fromStack);
                ((StringBuffer)object).append("; object=").append(object2);
                this.digester.log.debug(((StringBuffer)object).toString());
            }
        }
        if (object2 != null) {
            object = (Object[])this.digester.peekParams();
            object[this.paramIndex] = object2;
        }
    }

    public void body(String string) throws Exception {
        if (this.attributeName == null && !this.fromStack) {
            if (this.bodyTextStack == null) {
                this.bodyTextStack = new ArrayStack();
            }
            this.bodyTextStack.push(string.trim());
        }
    }

    public void end(String string, String string2) {
        if (this.bodyTextStack != null && !this.bodyTextStack.empty()) {
            Object[] objectArray = (Object[])this.digester.peekParams();
            objectArray[this.paramIndex] = this.bodyTextStack.pop();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CallParamRule[");
        stringBuffer.append("paramIndex=");
        stringBuffer.append(this.paramIndex);
        stringBuffer.append(", attributeName=");
        stringBuffer.append(this.attributeName);
        stringBuffer.append(", from stack=");
        stringBuffer.append(this.fromStack);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

