/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRDesignTextField
extends JRDesignTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    protected boolean isStretchWithOverflow = false;
    protected byte evaluationTime = 1;
    protected String pattern = null;
    protected Boolean isBlankWhenNull = null;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    private List hyperlinkParameters = new ArrayList();
    protected JRGroup evaluationGroup = null;
    protected JRExpression expression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;

    public JRDesignTextField() {
        super(null);
    }

    public JRDesignTextField(JRDefaultStyleProvider jRDefaultStyleProvider) {
        super(jRDefaultStyleProvider);
    }

    public boolean isStretchWithOverflow() {
        return this.isStretchWithOverflow;
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    public String getOwnPattern() {
        return this.pattern;
    }

    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setStretchWithOverflow(boolean bl) {
        this.isStretchWithOverflow = bl;
    }

    public void setEvaluationTime(byte by) {
        this.evaluationTime = by;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setBlankWhenNull(boolean bl) {
        this.isBlankWhenNull = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setBlankWhenNull(Boolean bl) {
        this.isBlankWhenNull = bl;
    }

    public void setHyperlinkType(byte by) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(by));
    }

    public void setHyperlinkTarget(byte by) {
        this.hyperlinkTarget = by;
    }

    public void setEvaluationGroup(JRGroup jRGroup) {
        this.evaluationGroup = jRGroup;
    }

    public void setExpression(JRExpression jRExpression) {
        this.expression = jRExpression;
    }

    public void setAnchorNameExpression(JRExpression jRExpression) {
        this.anchorNameExpression = jRExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression jRExpression) {
        this.hyperlinkReferenceExpression = jRExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression jRExpression) {
        this.hyperlinkAnchorExpression = jRExpression;
    }

    public void setHyperlinkPageExpression(JRExpression jRExpression) {
        this.hyperlinkPageExpression = jRExpression;
    }

    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getTextField(this);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeTextField(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int n) {
        this.bookmarkLevel = n;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String string) {
        this.linkType = string;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] jRHyperlinkParameterArray;
        if (this.hyperlinkParameters.isEmpty()) {
            jRHyperlinkParameterArray = null;
        } else {
            jRHyperlinkParameterArray = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(jRHyperlinkParameterArray);
        }
        return jRHyperlinkParameterArray;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.add(jRHyperlinkParameter);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.remove(jRHyperlinkParameter);
    }

    public void removeHyperlinkParameter(String string) {
        Iterator iterator = this.hyperlinkParameters.iterator();
        while (iterator.hasNext()) {
            JRHyperlinkParameter jRHyperlinkParameter = (JRHyperlinkParameter)iterator.next();
            if (jRHyperlinkParameter.getName() == null || !jRHyperlinkParameter.getName().equals(string)) continue;
            iterator.remove();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.normalizeLinkType();
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression jRExpression) {
        this.hyperlinkTooltipExpression = jRExpression;
    }
}

