/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseReport
implements JRReport,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String name = null;
    protected String language = "java";
    protected int columnCount = 1;
    protected byte printOrder = 1;
    protected int pageWidth = 595;
    protected int pageHeight = 842;
    protected byte orientation = 1;
    protected byte whenNoDataType = 1;
    protected int columnWidth = 555;
    protected int columnSpacing = 0;
    protected int leftMargin = 20;
    protected int rightMargin = 20;
    protected int topMargin = 30;
    protected int bottomMargin = 30;
    protected boolean isTitleNewPage = false;
    protected boolean isSummaryNewPage = false;
    protected boolean isFloatColumnFooter = false;
    protected boolean ignorePagination = false;
    protected String formatFactoryClass = null;
    protected Set importsSet = null;
    protected JRReportFont defaultFont = null;
    protected JRReportFont[] fonts = null;
    protected JRStyle defaultStyle = null;
    protected JRStyle[] styles = null;
    protected JRDataset mainDataset;
    protected JRDataset[] datasets;
    protected JRBand background = null;
    protected JRBand title = null;
    protected JRBand pageHeader = null;
    protected JRBand columnHeader = null;
    protected JRBand detail = null;
    protected JRBand columnFooter = null;
    protected JRBand pageFooter = null;
    protected JRBand lastPageFooter = null;
    protected JRBand summary = null;

    public JRBaseReport() {
    }

    public JRBaseReport(JRReport jRReport, JRExpressionCollector jRExpressionCollector) {
        this.name = jRReport.getName();
        this.language = jRReport.getLanguage();
        this.columnCount = jRReport.getColumnCount();
        this.printOrder = jRReport.getPrintOrder();
        this.pageWidth = jRReport.getPageWidth();
        this.pageHeight = jRReport.getPageHeight();
        this.orientation = jRReport.getOrientation();
        this.whenNoDataType = jRReport.getWhenNoDataType();
        this.columnWidth = jRReport.getColumnWidth();
        this.columnSpacing = jRReport.getColumnSpacing();
        this.leftMargin = jRReport.getLeftMargin();
        this.rightMargin = jRReport.getRightMargin();
        this.topMargin = jRReport.getTopMargin();
        this.bottomMargin = jRReport.getBottomMargin();
        this.isTitleNewPage = jRReport.isTitleNewPage();
        this.isSummaryNewPage = jRReport.isSummaryNewPage();
        this.isFloatColumnFooter = jRReport.isFloatColumnFooter();
        this.ignorePagination = jRReport.isIgnorePagination();
        this.formatFactoryClass = jRReport.getFormatFactoryClass();
        String[] stringArray = jRReport.getImports();
        if (stringArray != null && stringArray.length > 0) {
            this.importsSet = new HashSet(stringArray.length);
            this.importsSet.addAll(Arrays.asList(stringArray));
        }
        JRBaseObjectFactory jRBaseObjectFactory = new JRBaseObjectFactory(this, jRExpressionCollector);
        this.defaultFont = jRBaseObjectFactory.getReportFont(jRReport.getDefaultFont());
        JRReportFont[] jRReportFontArray = jRReport.getFonts();
        if (jRReportFontArray != null && jRReportFontArray.length > 0) {
            this.fonts = new JRReportFont[jRReportFontArray.length];
            int n = 0;
            while (n < this.fonts.length) {
                this.fonts[n] = jRBaseObjectFactory.getReportFont(jRReportFontArray[n]);
                ++n;
            }
        }
        this.defaultStyle = jRBaseObjectFactory.getStyle(jRReport.getDefaultStyle());
        JRStyle[] jRStyleArray = jRReport.getStyles();
        if (jRStyleArray != null && jRStyleArray.length > 0) {
            this.styles = new JRStyle[jRStyleArray.length];
            int n = 0;
            while (n < this.styles.length) {
                this.styles[n] = jRBaseObjectFactory.getStyle(jRStyleArray[n]);
                ++n;
            }
        }
        this.mainDataset = jRBaseObjectFactory.getDataset(jRReport.getMainDataset());
        JRDataset[] jRDatasetArray = jRReport.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            this.datasets = new JRDataset[jRDatasetArray.length];
            int n = 0;
            while (n < this.datasets.length) {
                this.datasets[n] = jRBaseObjectFactory.getDataset(jRDatasetArray[n]);
                ++n;
            }
        }
        this.background = jRBaseObjectFactory.getBand(jRReport.getBackground());
        this.title = jRBaseObjectFactory.getBand(jRReport.getTitle());
        this.pageHeader = jRBaseObjectFactory.getBand(jRReport.getPageHeader());
        this.columnHeader = jRBaseObjectFactory.getBand(jRReport.getColumnHeader());
        this.detail = jRBaseObjectFactory.getBand(jRReport.getDetail());
        this.columnFooter = jRBaseObjectFactory.getBand(jRReport.getColumnFooter());
        this.pageFooter = jRBaseObjectFactory.getBand(jRReport.getPageFooter());
        this.lastPageFooter = jRBaseObjectFactory.getBand(jRReport.getLastPageFooter());
        this.summary = jRBaseObjectFactory.getBand(jRReport.getSummary());
    }

    public JRBaseReport(JRReport jRReport) {
        this(jRReport, null);
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public byte getPrintOrder() {
        return this.printOrder;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public byte getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(byte by) {
        this.whenNoDataType = by;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public boolean isTitleNewPage() {
        return this.isTitleNewPage;
    }

    public boolean isSummaryNewPage() {
        return this.isSummaryNewPage;
    }

    public boolean isFloatColumnFooter() {
        return this.isFloatColumnFooter;
    }

    public String getScriptletClass() {
        return this.mainDataset.getScriptletClass();
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public String getResourceBundle() {
        return this.mainDataset.getResourceBundle();
    }

    public String[] getPropertyNames() {
        return this.mainDataset.getPropertiesMap().getPropertyNames();
    }

    public String getProperty(String string) {
        return this.mainDataset.getPropertiesMap().getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.mainDataset.getPropertiesMap().setProperty(string, string2);
    }

    public void removeProperty(String string) {
        this.mainDataset.getPropertiesMap().removeProperty(string);
    }

    public String[] getImports() {
        if (this.importsSet != null) {
            return this.importsSet.toArray(new String[this.importsSet.size()]);
        }
        return null;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRReportFont[] getFonts() {
        return this.fonts;
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public JRStyle[] getStyles() {
        return this.styles;
    }

    public JRParameter[] getParameters() {
        return this.mainDataset.getParameters();
    }

    public JRQuery getQuery() {
        return this.mainDataset.getQuery();
    }

    public JRField[] getFields() {
        return this.mainDataset.getFields();
    }

    public JRSortField[] getSortFields() {
        return this.mainDataset.getSortFields();
    }

    public JRVariable[] getVariables() {
        return this.mainDataset.getVariables();
    }

    public JRGroup[] getGroups() {
        return this.mainDataset.getGroups();
    }

    public JRBand getBackground() {
        return this.background;
    }

    public JRBand getTitle() {
        return this.title;
    }

    public JRBand getPageHeader() {
        return this.pageHeader;
    }

    public JRBand getColumnHeader() {
        return this.columnHeader;
    }

    public JRBand getDetail() {
        return this.detail;
    }

    public JRBand getColumnFooter() {
        return this.columnFooter;
    }

    public JRBand getPageFooter() {
        return this.pageFooter;
    }

    public JRBand getLastPageFooter() {
        return this.lastPageFooter;
    }

    public JRBand getSummary() {
        return this.summary;
    }

    public byte getWhenResourceMissingType() {
        return this.mainDataset.getWhenResourceMissingType();
    }

    public void setWhenResourceMissingType(byte by) {
        this.mainDataset.setWhenResourceMissingType(by);
    }

    public JRDataset getMainDataset() {
        return this.mainDataset;
    }

    public JRDataset[] getDatasets() {
        return this.datasets;
    }

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.mainDataset.getPropertiesMap();
    }
}

