/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeries;
import net.sf.jasperreports.charts.util.TimeSeriesLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class JRFillTimeSeriesDataset
extends JRFillChartDataset
implements JRTimeSeriesDataset {
    protected JRFillTimeSeries[] timeSeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;
    private Map itemHyperlinks;

    public JRFillTimeSeriesDataset(JRTimeSeriesDataset jRTimeSeriesDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRTimeSeriesDataset, jRFillObjectFactory);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            this.timeSeries = new JRFillTimeSeries[jRTimeSeriesArray.length];
            int n = 0;
            while (n < this.timeSeries.length) {
                this.timeSeries[n] = (JRFillTimeSeries)jRFillObjectFactory.getTimeSeries(jRTimeSeriesArray[n]);
                ++n;
            }
        }
    }

    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            int n = 0;
            while (n < this.timeSeries.length) {
                this.timeSeries[n].evaluate(jRCalculator);
                ++n;
            }
        }
    }

    protected void customIncrement() {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            int n = 0;
            while (n < this.timeSeries.length) {
                Map<RegularTimePeriod, String> map;
                JRFillTimeSeries jRFillTimeSeries = this.timeSeries[n];
                Comparable comparable = jRFillTimeSeries.getSeries();
                TimeSeries timeSeries = (TimeSeries)this.seriesMap.get(comparable);
                if (timeSeries == null) {
                    timeSeries = new TimeSeries(comparable.toString(), this.getTimePeriod());
                    this.seriesNames.add(comparable);
                    this.seriesMap.put(comparable, timeSeries);
                }
                RegularTimePeriod regularTimePeriod = RegularTimePeriod.createInstance(this.getTimePeriod(), jRFillTimeSeries.getTimePeriod(), this.getTimeZone());
                timeSeries.addOrUpdate(regularTimePeriod, jRFillTimeSeries.getValue());
                if (jRFillTimeSeries.getLabelExpression() != null) {
                    map = (HashMap<RegularTimePeriod, String>)this.labelsMap.get(comparable);
                    if (map == null) {
                        map = new HashMap<RegularTimePeriod, String>();
                        this.labelsMap.put(comparable, map);
                    }
                    map.put(regularTimePeriod, jRFillTimeSeries.getLabel());
                }
                if (jRFillTimeSeries.hasItemHyperlink()) {
                    map = (Map)this.itemHyperlinks.get(comparable);
                    if (map == null) {
                        map = new HashMap();
                        this.itemHyperlinks.put(comparable, map);
                    }
                    map.put(regularTimePeriod, (String)((Object)jRFillTimeSeries.getPrintItemHyperlink()));
                }
                ++n;
            }
        }
    }

    public Dataset getCustomDataset() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        if (this.seriesNames != null) {
            int n = 0;
            while (n < this.seriesNames.size()) {
                Comparable comparable = (Comparable)this.seriesNames.get(n);
                timeSeriesCollection.addSeries((TimeSeries)this.seriesMap.get(comparable));
                ++n;
            }
        }
        return timeSeriesCollection;
    }

    public Class getTimePeriod() {
        return ((JRTimeSeriesDataset)this.parent).getTimePeriod();
    }

    public void setTimePeriod(Class clazz) {
    }

    public byte getDatasetType() {
        return 6;
    }

    public TimeSeriesLabelGenerator getLabelGenerator() {
        return new TimeSeriesLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean bl = false;
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            int n = 0;
            while (n < this.timeSeries.length && !bl) {
                bl = this.timeSeries[n].hasItemHyperlink();
                ++n;
            }
        }
        return bl;
    }

    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }
}

