/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.DataUtilities;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedAreaRenderer
extends AreaRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3595635038460823663L;
    private boolean renderAsPercentages;

    public StackedAreaRenderer() {
        this(false);
    }

    public StackedAreaRenderer(boolean bl) {
        this.renderAsPercentages = bl;
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl) {
        this.renderAsPercentages = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Object object;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = 0.0;
        if (this.renderAsPercentages) {
            d2 = DataUtilities.calculateColumnTotal(categoryDataset, n2);
            d /= d2;
        }
        double d3 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d4 = this.getPreviousHeight(categoryDataset, n, n2);
        double d5 = d + d4;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d6 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.setStroke(this.getItemStroke(n, n2));
        if (n2 == 0) {
            if (n3 == 1 && this.isItemLabelVisible(n, n2)) {
                this.drawItemLabel(graphics2D, categoryPlot.getOrientation(), categoryDataset, n, n2, d3, d6, d5 < 0.0);
            }
        } else {
            object = categoryDataset.getValue(n, n2 - 1);
            if (object != null) {
                double d7 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
                double d8 = ((Number)object).doubleValue();
                if (this.renderAsPercentages) {
                    d2 = DataUtilities.calculateColumnTotal(categoryDataset, n2 - 1);
                    d8 /= d2;
                }
                double d9 = this.getPreviousHeight(categoryDataset, n, n2 - 1);
                double d10 = valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge);
                double d11 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
                double d12 = valueAxis.valueToJava2D(d8 += d9, rectangle2D, rectangleEdge);
                if (n3 == 0) {
                    Polygon polygon = null;
                    PlotOrientation plotOrientation = categoryPlot.getOrientation();
                    if (plotOrientation == PlotOrientation.HORIZONTAL) {
                        polygon = new Polygon();
                        polygon.addPoint((int)d12, (int)d7);
                        polygon.addPoint((int)d6, (int)d3);
                        polygon.addPoint((int)d11, (int)d3);
                        polygon.addPoint((int)d10, (int)d7);
                    } else if (plotOrientation == PlotOrientation.VERTICAL) {
                        polygon = new Polygon();
                        polygon.addPoint((int)d7, (int)d12);
                        polygon.addPoint((int)d3, (int)d6);
                        polygon.addPoint((int)d3, (int)d11);
                        polygon.addPoint((int)d7, (int)d10);
                    }
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                    graphics2D.setStroke(this.getItemStroke(n, n2));
                    graphics2D.fill(polygon);
                } else if (this.isItemLabelVisible(n, n2)) {
                    this.drawItemLabel(graphics2D, categoryPlot.getOrientation(), categoryDataset, n, n2, d3, d6, d5 < 0.0);
                }
            }
        }
        if ((object = categoryItemRendererState.getEntityCollection()) != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - 3.0, d6 - 3.0, 6.0, 6.0);
            this.addItemEntity((EntityCollection)object, categoryDataset, n, n2, double_);
        }
    }

    protected double getPreviousHeight(CategoryDataset categoryDataset, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.renderAsPercentages) {
            d2 = DataUtilities.calculateColumnTotal(categoryDataset, n2);
        }
        int n3 = 0;
        while (n3 < n) {
            Number number = categoryDataset.getValue(n3, n2);
            if (number != null) {
                double d3 = number.doubleValue();
                if (this.renderAsPercentages) {
                    d3 /= d2;
                }
                d += d3;
            }
            ++n3;
        }
        return d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedAreaRenderer)) {
            return false;
        }
        StackedAreaRenderer stackedAreaRenderer = (StackedAreaRenderer)object;
        if (this.renderAsPercentages != stackedAreaRenderer.renderAsPercentages) {
            return false;
        }
        return super.equals(object);
    }
}

