/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;

public class GenericXMLWriter
extends PrintWriter {
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private int tab = 0;
    private String lineSeparator;

    private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
        String string = GenericXMLWriter.getReplacement(c);
        if (string != null) {
            stringBuffer.append('&');
            stringBuffer.append(string);
            stringBuffer.append(';');
        } else {
            stringBuffer.append(c);
        }
    }

    private static String getEscaped(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            GenericXMLWriter.appendEscapedChar(stringBuffer, string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    public GenericXMLWriter(OutputStream outputStream, String string, boolean bl) {
        this(new PrintWriter(outputStream), string, bl);
    }

    public GenericXMLWriter(Writer writer, String string, boolean bl) {
        super(writer);
        this.lineSeparator = string;
        if (bl) {
            this.print(XML_VERSION);
            this.print(this.lineSeparator);
        }
    }

    public void endTag(String string, boolean bl, boolean bl2) {
        --this.tab;
        this.printTag(String.valueOf('/') + string, null, bl, bl2, false);
    }

    private void printTabulation() {
        int n = 0;
        while (n < this.tab) {
            super.print('\t');
            ++n;
        }
    }

    public void printTag(String string, HashMap hashMap, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (hashMap != null) {
            int n = hashMap.size();
            Object[] objectArray = new String[n];
            hashMap.keySet().toArray(objectArray);
            Arrays.sort(objectArray);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(" ");
                stringBuffer.append((String)objectArray[n2]);
                stringBuffer.append("=\"");
                stringBuffer.append(GenericXMLWriter.getEscaped(String.valueOf(hashMap.get(objectArray[n2]))));
                stringBuffer.append("\"");
                ++n2;
            }
        }
        if (bl3) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
        }
        this.printString(stringBuffer.toString(), bl, bl2);
        if (hashMap != null && !bl3) {
            ++this.tab;
        }
    }

    public void printString(String string, boolean bl, boolean bl2) {
        if (bl) {
            this.printTabulation();
        }
        this.print(string);
        if (bl2) {
            this.print(this.lineSeparator);
        }
    }

    public void startTag(String string, boolean bl) {
        this.printTag(string, null, bl, true, false);
        ++this.tab;
    }
}

