/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedGenericMethodBinding
extends ParameterizedMethodBinding
implements Substitution {
    public TypeBinding[] typeArguments;
    private LookupEnvironment environment;
    public boolean inferredReturnType;
    public boolean wasInferred;
    public boolean isRaw;
    private MethodBinding tiebreakMethod;
    public boolean isUnchecked;

    public static MethodBinding computeCompatibleMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray, Scope scope, InvocationSite invocationSite) {
        Object object;
        int n;
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        TypeBinding[] typeBindingArray2 = invocationSite.genericTypeArguments();
        if (typeBindingArray2 != null) {
            if (typeBindingArray2.length != typeVariableBindingArray.length) {
                return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray2, 11);
            }
            parameterizedGenericMethodBinding = scope.environment().createParameterizedGenericMethod(methodBinding, typeBindingArray2);
        } else {
            TypeBinding[] typeBindingArray3 = methodBinding.parameters;
            n = typeVariableBindingArray.length;
            object = new HashMap<TypeVariableBinding, TypeBinding[][]>(n);
            int n2 = 0;
            while (n2 < n) {
                object.put(typeVariableBindingArray[n2], new TypeBinding[3][]);
                ++n2;
            }
            typeBindingArray2 = new TypeBinding[n];
            parameterizedGenericMethodBinding = ParameterizedGenericMethodBinding.inferFromArgumentTypes(scope, methodBinding, typeBindingArray, typeBindingArray3, object, typeBindingArray2);
            if (parameterizedGenericMethodBinding == null) {
                return null;
            }
            if (ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(typeBindingArray2)) {
                TypeBinding typeBinding = null;
                if (parameterizedGenericMethodBinding.returnType != TypeBinding.VOID) {
                    if (invocationSite instanceof MessageSend) {
                        MessageSend messageSend = (MessageSend)invocationSite;
                        typeBinding = messageSend.expectedType;
                    }
                    if (typeBinding == null) {
                        typeBinding = scope.getJavaLangObject();
                    }
                }
                if ((parameterizedGenericMethodBinding = parameterizedGenericMethodBinding.inferFromExpectedType(scope, typeBinding, (Map)object, typeBindingArray2)) == null) {
                    return null;
                }
            }
        }
        if (!parameterizedGenericMethodBinding.isRaw) {
            int n3 = 0;
            n = typeVariableBindingArray.length;
            while (n3 < n) {
                object = typeVariableBindingArray[n3];
                TypeBinding typeBinding = parameterizedGenericMethodBinding.typeArguments[n3];
                switch (((TypeVariableBinding)object).boundCheck(parameterizedGenericMethodBinding, typeBinding)) {
                    case 2: {
                        int n4 = typeBindingArray.length;
                        TypeBinding[] typeBindingArray4 = new TypeBinding[n4 + 2];
                        System.arraycopy(typeBindingArray, 0, typeBindingArray4, 0, n4);
                        typeBindingArray4[n4] = typeBinding;
                        typeBindingArray4[n4 + 1] = object;
                        return new ProblemMethodBinding(parameterizedGenericMethodBinding, methodBinding.selector, typeBindingArray4, 10);
                    }
                    case 1: {
                        parameterizedGenericMethodBinding.isUnchecked = true;
                    }
                }
                ++n3;
            }
        }
        return parameterizedGenericMethodBinding;
    }

    private static boolean hasUnresolvedTypeArgument(TypeBinding[] typeBindingArray) {
        int n = 0;
        int n2 = typeBindingArray.length;
        while (n < n2) {
            if (typeBindingArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static ParameterizedGenericMethodBinding inferFromArgumentTypes(Scope var0, MethodBinding var1_1, TypeBinding[] var2_2, TypeBinding[] var3_3, Map var4_4, TypeBinding[] var5_5) {
        block18: {
            block17: {
                block20: {
                    block19: {
                        if (!var1_1.isVarargs()) break block17;
                        var6_6 = var3_3.length;
                        var7_8 = var6_6 - 1;
                        var8_9 = var2_2.length;
                        var9_11 = 0;
                        while (var9_11 < var7_8) {
                            var3_3[var9_11].collectSubstitutes(var0, var2_2[var9_11], var4_4, 1);
                            if (var4_4.get(TypeBinding.VOID) != null) {
                                return null;
                            }
                            ++var9_11;
                        }
                        if (var7_8 >= var8_9) break block18;
                        var9_12 = var3_3[var7_8];
                        var10_14 = var2_2[var7_8];
                        if (var6_6 != var8_9) break block19;
                        if (var10_14 == TypeBinding.NULL) break block20;
                        switch (var10_14.dimensions()) {
                            case 0: {
                                ** break;
                            }
                            case 1: {
                                if (var10_14.leafComponentType().isBaseType()) ** break;
                                break block20;
                            }
                            default: {
                                break block20;
                            }
                        }
                    }
                    var9_12 = ((ArrayBinding)var9_12).elementsType();
                }
                var11_15 = var7_8;
                while (var11_15 < var8_9) {
                    var9_12.collectSubstitutes(var0, var2_2[var11_15], var4_4, 1);
                    if (var4_4.get(TypeBinding.VOID) != null) {
                        return null;
                    }
                    ++var11_15;
                }
                break block18;
            }
            var6_6 = var3_3.length;
            var7_8 = 0;
            while (var7_8 < var6_6) {
                var3_3[var7_8].collectSubstitutes(var0, var2_2[var7_8], var4_4, 1);
                if (var4_4.get(TypeBinding.VOID) != null) {
                    return null;
                }
                ++var7_8;
            }
        }
        var6_7 = var1_1.typeVariables;
        var7_8 = var6_7.length;
        if ((var5_5 = ParameterizedGenericMethodBinding.resolveSubstituteConstraints(var0, var6_7, var5_5, false, var4_4)) == null) {
            return null;
        }
        if (var5_5.length == 0) {
            return var0.environment().createParameterizedGenericMethod(var1_1, (RawTypeBinding)null);
        }
        var8_10 = var5_5;
        var9_13 = 0;
        while (var9_13 < var7_8) {
            if (var5_5[var9_13] == null) {
                if (var8_10 == var5_5) {
                    var8_10 = new TypeBinding[var7_8];
                    System.arraycopy(var5_5, 0, var8_10, 0, var9_13);
                }
                var8_10[var9_13] = var6_7[var9_13];
            } else if (var8_10 != var5_5) {
                var8_10[var9_13] = var5_5[var9_13];
            }
            ++var9_13;
        }
        return var0.environment().createParameterizedGenericMethod(var1_1, var8_10);
    }

    private static TypeBinding[] resolveSubstituteConstraints(Scope scope, TypeVariableBinding[] typeVariableBindingArray, TypeBinding[] typeBindingArray, boolean bl, Map map) {
        TypeBinding[][] typeBindingArray2;
        TypeBinding[] typeBindingArray3;
        TypeBinding typeBinding;
        TypeVariableBinding typeVariableBinding;
        if (map.isEmpty()) {
            return Binding.NO_TYPES;
        }
        int n = typeVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            typeVariableBinding = typeVariableBindingArray[n2];
            typeBinding = typeBindingArray[n2];
            if (typeBinding == null && (typeBindingArray3 = (typeBindingArray2 = (TypeBinding[][])map.get(typeVariableBinding))[0]) != null) {
                int n3 = 0;
                int n4 = typeBindingArray3.length;
                block1: while (n3 < n4) {
                    TypeBinding typeBinding2 = typeBindingArray3[n3];
                    if (typeBinding2 != null) {
                        if (typeBinding2 == typeVariableBinding) {
                            int n5 = n3 + 1;
                            while (n5 < n4) {
                                typeBinding2 = typeBindingArray3[n5];
                                if (typeBinding2 != typeVariableBinding && typeBinding2 != null) {
                                    typeBindingArray[n2] = typeBinding2;
                                    break block1;
                                }
                                ++n5;
                            }
                            typeBindingArray[n2] = typeVariableBinding;
                            break;
                        }
                        typeBindingArray[n2] = typeBinding2;
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(typeBindingArray)) {
            n2 = 0;
            while (n2 < n) {
                typeVariableBinding = typeVariableBindingArray[n2];
                typeBinding = typeBindingArray[n2];
                if (typeBinding == null && (typeBindingArray3 = (typeBindingArray2 = (TypeBinding[][])map.get(typeVariableBinding))[2]) != null) {
                    TypeBinding typeBinding3 = scope.lowerUpperBound(typeBindingArray3);
                    if (typeBinding3 == null) {
                        return null;
                    }
                    if (typeBinding3 != TypeBinding.VOID) {
                        typeBindingArray[n2] = typeBinding3;
                    }
                }
                ++n2;
            }
        }
        if (bl && ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(typeBindingArray)) {
            n2 = 0;
            while (n2 < n) {
                typeVariableBinding = typeVariableBindingArray[n2];
                typeBinding = typeBindingArray[n2];
                if (typeBinding == null && (typeBindingArray3 = (typeBindingArray2 = (TypeBinding[][])map.get(typeVariableBinding))[1]) != null) {
                    TypeBinding[] typeBindingArray4 = Scope.greaterLowerBound(typeBindingArray3);
                    TypeBinding typeBinding4 = null;
                    if (typeBindingArray4 != null) {
                        typeBinding4 = typeBindingArray4[0];
                    }
                    if (typeBinding4 != null) {
                        typeBindingArray[n2] = typeBinding4;
                    }
                }
                ++n2;
            }
        }
        return typeBindingArray;
    }

    public ParameterizedGenericMethodBinding(MethodBinding methodBinding, RawTypeBinding rawTypeBinding, LookupEnvironment lookupEnvironment) {
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        int n = typeVariableBindingArray.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        int n2 = 0;
        while (n2 < n) {
            typeBindingArray[n2] = lookupEnvironment.convertToRawType(typeVariableBindingArray[n2].erasure());
            ++n2;
        }
        this.isRaw = true;
        this.tagBits = methodBinding.tagBits;
        this.isUnchecked = false;
        this.environment = lookupEnvironment;
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.declaringClass = rawTypeBinding == null ? methodBinding.declaringClass : rawTypeBinding;
        this.typeVariables = Binding.NO_TYPE_VARIABLES;
        this.typeArguments = typeBindingArray;
        this.originalMethod = methodBinding;
        n2 = rawTypeBinding != null && !methodBinding.isStatic() ? 0 : 1;
        this.parameters = Scope.substitute((Substitution)this, n2 != 0 ? methodBinding.parameters : Scope.substitute((Substitution)rawTypeBinding, methodBinding.parameters));
        this.thrownExceptions = Scope.substitute((Substitution)this, n2 != 0 ? methodBinding.thrownExceptions : Scope.substitute((Substitution)rawTypeBinding, methodBinding.thrownExceptions));
        this.returnType = Scope.substitute((Substitution)this, n2 != 0 ? methodBinding.returnType : Scope.substitute((Substitution)rawTypeBinding, methodBinding.returnType));
        this.wasInferred = false;
    }

    public ParameterizedGenericMethodBinding(MethodBinding methodBinding, TypeBinding[] typeBindingArray, LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.declaringClass = methodBinding.declaringClass;
        this.typeVariables = Binding.NO_TYPE_VARIABLES;
        this.typeArguments = typeBindingArray;
        this.isRaw = false;
        this.tagBits = methodBinding.tagBits;
        this.isUnchecked = false;
        this.originalMethod = methodBinding;
        this.parameters = Scope.substitute((Substitution)this, methodBinding.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, methodBinding.thrownExceptions);
        this.returnType = Scope.substitute((Substitution)this, methodBinding.returnType);
        this.wasInferred = true;
    }

    public char[] computeUniqueKey(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.originalMethod.computeUniqueKey(false));
        stringBuffer.append('%');
        stringBuffer.append('<');
        if (!this.isRaw) {
            n = this.typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding typeBinding = this.typeArguments[n2];
                stringBuffer.append(typeBinding.computeUniqueKey(false));
                ++n2;
            }
        }
        stringBuffer.append('>');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public boolean hasSubstitutedParameters() {
        if (this.wasInferred) {
            return this.originalMethod.hasSubstitutedParameters();
        }
        return super.hasSubstitutedParameters();
    }

    public boolean hasSubstitutedReturnType() {
        if (this.inferredReturnType) {
            return this.originalMethod.hasSubstitutedReturnType();
        }
        return super.hasSubstitutedReturnType();
    }

    private ParameterizedGenericMethodBinding inferFromExpectedType(Scope scope, TypeBinding typeBinding, Map map, TypeBinding[] typeBindingArray) {
        TypeBinding typeBinding2;
        TypeVariableBinding[] typeVariableBindingArray = this.originalMethod.typeVariables;
        int n = typeVariableBindingArray.length;
        if (typeBinding != null) {
            this.returnType.collectSubstitutes(scope, typeBinding, map, 2);
            if (map.get(TypeBinding.VOID) != null) {
                return null;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            TypeBinding typeBinding3 = this.typeArguments[n2];
            typeBinding2 = typeVariableBindingArray[n2];
            boolean bl2 = bl = typeBinding3 != typeBinding2;
            if (typeBinding2.firstBound == typeBinding2.superclass) {
                TypeBinding typeBinding4 = Scope.substitute((Substitution)this, typeBinding2.superclass);
                typeBinding3.collectSubstitutes(scope, typeBinding4, map, 2);
                if (map.get(TypeBinding.VOID) != null) {
                    return null;
                }
                if (bl) {
                    typeBinding4.collectSubstitutes(scope, typeBinding3, map, 1);
                    if (map.get(TypeBinding.VOID) != null) {
                        return null;
                    }
                }
            }
            int n3 = 0;
            int n4 = typeBinding2.superInterfaces.length;
            while (n3 < n4) {
                TypeBinding typeBinding5 = Scope.substitute((Substitution)this, typeBinding2.superInterfaces[n3]);
                typeBinding3.collectSubstitutes(scope, typeBinding5, map, 2);
                if (map.get(TypeBinding.VOID) != null) {
                    return null;
                }
                if (bl) {
                    typeBinding5.collectSubstitutes(scope, typeBinding3, map, 1);
                    if (map.get(TypeBinding.VOID) != null) {
                        return null;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        if ((typeBindingArray = ParameterizedGenericMethodBinding.resolveSubstituteConstraints(scope, typeVariableBindingArray, typeBindingArray, true, map)) == null) {
            return null;
        }
        if (typeBindingArray.length == 0) {
            this.isRaw = true;
            this.isUnchecked = false;
            n2 = 0;
            while (n2 < n) {
                this.typeArguments[n2] = typeVariableBindingArray[n2].upperBound();
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < n) {
                typeBinding2 = typeBindingArray[n2];
                this.typeArguments[n2] = typeBinding2 != null ? typeBindingArray[n2] : typeVariableBindingArray[n2].upperBound();
                ++n2;
            }
        }
        this.typeArguments = Scope.substitute((Substitution)this, this.typeArguments);
        TypeBinding typeBinding6 = this.returnType;
        this.returnType = Scope.substitute((Substitution)this, this.returnType);
        this.inferredReturnType = this.returnType != typeBinding6;
        this.parameters = Scope.substitute((Substitution)this, this.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, this.thrownExceptions);
        return this;
    }

    public boolean isRawSubstitution() {
        return this.isRaw;
    }

    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        TypeVariableBinding[] typeVariableBindingArray = this.originalMethod.typeVariables;
        int n = typeVariableBindingArray.length;
        if (typeVariableBinding.rank < n && typeVariableBindingArray[typeVariableBinding.rank] == typeVariableBinding) {
            return this.typeArguments[typeVariableBinding.rank];
        }
        if (!this.isStatic() && this.declaringClass instanceof Substitution) {
            return ((Substitution)((Object)this.declaringClass)).substitute(typeVariableBinding);
        }
        return typeVariableBinding;
    }

    public MethodBinding tiebreakMethod() {
        if (this.tiebreakMethod == null) {
            TypeVariableBinding[] typeVariableBindingArray = this.originalMethod.typeVariables;
            int n = typeVariableBindingArray.length;
            TypeBinding[] typeBindingArray = new TypeBinding[n];
            int n2 = 0;
            while (n2 < n) {
                typeBindingArray[n2] = this.environment.convertToRawType(typeVariableBindingArray[n2].upperBound());
                ++n2;
            }
            this.tiebreakMethod = this.environment.createParameterizedGenericMethod(this.originalMethod, typeBindingArray);
        }
        return this.tiebreakMethod;
    }
}

