/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public abstract class AbstractMethodDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    public char[] selector;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public Argument[] arguments;
    public TypeReference[] thrownExceptions;
    public Statement[] statements;
    public int explicitDeclarations;
    public MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public boolean needFreeReturn = false;
    public Javadoc javadoc;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;
    public boolean errorInSignature = false;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortMethod(this.compilationResult, categorizedProblem);
    }

    public abstract void analyseCode(ClassScope var1, InitializationFlowContext var2, FlowInfo var3);

    public void bindArguments() {
        if (this.arguments != null) {
            if (this.binding == null) {
                int n = 0;
                int n2 = this.arguments.length;
                while (n < n2) {
                    this.arguments[n].bind(this.scope, null, true);
                    ++n;
                }
                return;
            }
            boolean bl = this.binding.isAbstract() || this.binding.isNative();
            AnnotationBinding[][] annotationBindingArrayArray = null;
            int n = 0;
            int n3 = this.arguments.length;
            while (n < n3) {
                Argument argument = this.arguments[n];
                argument.bind(this.scope, this.binding.parameters[n], bl);
                if (argument.annotations != null) {
                    this.binding.tagBits |= 0x400L;
                    if (annotationBindingArrayArray == null) {
                        annotationBindingArrayArray = new AnnotationBinding[n3][];
                    }
                    annotationBindingArrayArray[n] = argument.binding.getAnnotations();
                }
                ++n;
            }
            if (annotationBindingArrayArray != null) {
                this.binding.setParameterAnnotations(annotationBindingArrayArray);
            }
        }
    }

    public void bindThrownExceptions() {
        block9: {
            if (this.thrownExceptions == null || this.binding == null || this.binding.thrownExceptions == null) break block9;
            int n = this.binding.thrownExceptions.length;
            int n2 = this.thrownExceptions.length;
            if (n == n2) {
                int n3 = 0;
                while (n3 < n) {
                    this.thrownExceptions[n3].resolvedType = this.binding.thrownExceptions[n3];
                    ++n3;
                }
            } else {
                int n4 = 0;
                int n5 = 0;
                while (n5 < n2 && n4 < n) {
                    TypeReference typeReference = this.thrownExceptions[n5];
                    ReferenceBinding referenceBinding = this.binding.thrownExceptions[n4];
                    char[][] cArray = referenceBinding.compoundName;
                    if (cArray != null) {
                        if (typeReference instanceof SingleTypeReference) {
                            int n6 = cArray.length;
                            char[] cArray2 = typeReference.getTypeName()[0];
                            if (CharOperation.equals(cArray2, cArray[n6 - 1])) {
                                typeReference.resolvedType = referenceBinding;
                                ++n4;
                            }
                        } else if (CharOperation.equals(typeReference.getTypeName(), cArray)) {
                            typeReference.resolvedType = referenceBinding;
                            ++n4;
                        }
                    }
                    ++n5;
                }
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        classFile.codeStream.wideMode = false;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int n2 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n2];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n2);
            classFile.addProblemMethod(this, this.binding, categorizedProblemArray2);
            return;
        }
        try {
            n = classFile.contentsOffset;
            this.generateCode(classFile);
        }
        catch (AbortMethod abortMethod) {
            if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.generateCode(classFile);
                }
                catch (AbortMethod abortMethod2) {
                    CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
                    int n3 = categorizedProblemArray.length;
                    CategorizedProblem[] categorizedProblemArray3 = new CategorizedProblem[n3];
                    System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray3, 0, n3);
                    classFile.addProblemMethod(this, this.binding, categorizedProblemArray3, n);
                }
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int n4 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray4 = new CategorizedProblem[n4];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray4, 0, n4);
            classFile.addProblemMethod(this, this.binding, categorizedProblemArray4, n);
        }
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttribute(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n3;
            int n4;
            int n5 = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            this.scope.computeLocalVariablePositions(this.binding.isStatic() ? 0 : 1, codeStream);
            if (this.arguments != null) {
                n4 = 0;
                n3 = this.arguments.length;
                while (n4 < n3) {
                    LocalVariableBinding localVariableBinding = this.arguments[n4].binding;
                    codeStream.addVisibleLocalVariable(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    ++n4;
                }
            }
            if (this.statements != null) {
                n4 = 0;
                n3 = this.statements.length;
                while (n4 < n3) {
                    this.statements[n4].generateCode(this.scope, codeStream);
                    ++n4;
                }
            }
            if (this.needFreeReturn) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.declarationSourceEnd);
            classFile.completeCodeAttribute(n5);
            ++n2;
        } else {
            this.checkArgumentsSize();
        }
        classFile.completeMethodInfo(n, n2);
        if (this.ignoreFurtherInvestigation) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    private void checkArgumentsSize() {
        TypeBinding[] typeBindingArray = this.binding.parameters;
        int n = 1;
        int n2 = 0;
        int n3 = typeBindingArray.length;
        while (n2 < n3) {
            TypeBinding typeBinding = typeBindingArray[n2];
            n = typeBinding == TypeBinding.LONG || typeBinding == TypeBinding.DOUBLE ? (n += 2) : ++n;
            if (n > 255) {
                this.scope.problemReporter().noMoreAvailableSpaceForArgument(this.scope.locals[n2], this.scope.locals[n2].declaration);
            }
            ++n2;
        }
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationMethod() {
        return false;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isNative() {
        if (this.binding != null) {
            return this.binding.isNative();
        }
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        TypeParameter[] typeParameterArray;
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        AbstractMethodDeclaration.printIndent(n, stringBuffer);
        AbstractMethodDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            AbstractMethodDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        if ((typeParameterArray = this.typeParameters()) != null) {
            stringBuffer.append('<');
            n2 = typeParameterArray.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                typeParameterArray[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            typeParameterArray[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        this.printReturnType(0, stringBuffer).append(this.selector).append('(');
        if (this.arguments != null) {
            n2 = 0;
            while (n2 < this.arguments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append(')');
        if (this.thrownExceptions != null) {
            stringBuffer.append(" throws ");
            n2 = 0;
            while (n2 < this.thrownExceptions.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.thrownExceptions[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        this.printBody(n + 1, stringBuffer);
        return stringBuffer;
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return stringBuffer.append(';');
        }
        stringBuffer.append(" {");
        if (this.statements != null) {
            int n2 = 0;
            while (n2 < this.statements.length) {
                stringBuffer.append('\n');
                this.statements[n2].printStatement(n, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append('\n');
        AbstractMethodDeclaration.printIndent(n == 0 ? 0 : n - 1, stringBuffer).append('}');
        return stringBuffer;
    }

    public StringBuffer printReturnType(int n, StringBuffer stringBuffer) {
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            this.bindArguments();
            this.bindThrownExceptions();
            this.resolveJavadoc();
            AbstractMethodDeclaration.resolveAnnotations(this.scope, this.annotations, this.binding);
            this.resolveStatements();
            if (this.binding != null && (this.binding.getAnnotationTagBits() & 0x200000000000L) == 0L && (this.binding.modifiers & 0x100000) != 0 && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
                this.scope.problemReporter().missingDeprecatedAnnotationForMethod(this);
            }
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveJavadoc() {
        if (this.binding == null) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
            return;
        }
        if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            int n = 0;
            int n2 = this.statements.length;
            while (n < n2) {
                this.statements[n].resolve(this.scope);
                ++n;
            }
        } else if ((this.bits & 8) != 0) {
            this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd + 1);
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
    }

    public TypeParameter[] typeParameters() {
        return null;
    }
}

