/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo _info;
    private AlgorithmIdentifier _encAlg;
    private ASN1OctetString _encryptedKey;

    public KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, InputStream inputStream) {
        super(algorithmIdentifier, AlgorithmIdentifier.getInstance(keyAgreeRecipientInfo.getKeyEncryptionAlgorithm()), inputStream);
        this._info = keyAgreeRecipientInfo;
        this._encAlg = algorithmIdentifier;
        try {
            ASN1Sequence aSN1Sequence = this._info.getRecipientEncryptedKeys();
            RecipientEncryptedKey recipientEncryptedKey = RecipientEncryptedKey.getInstance(aSN1Sequence.getObjectAt(0));
            IssuerAndSerialNumber issuerAndSerialNumber = recipientEncryptedKey.getIdentifier().getIssuerAndSerialNumber();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(issuerAndSerialNumber.getName());
            this._rid = new RecipientId();
            this._rid.setIssuer(byteArrayOutputStream.toByteArray());
            this._rid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            this._encryptedKey = recipientEncryptedKey.getEncryptedKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid rid in KeyAgreeRecipientInformation");
        }
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        try {
            OriginatorPublicKey originatorPublicKey = this._info.getOriginator().getOriginatorKey();
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(key.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(privateKeyInfo.getAlgorithmId(), originatorPublicKey.getPublicKey().getBytes());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(this._keyEncAlg.getObjectId().getId(), string);
            KeyAgreement keyAgreement = KeyAgreement.getInstance(this._keyEncAlg.getObjectId().getId(), string);
            keyAgreement.init(key);
            keyAgreement.doPhase(keyFactory.generatePublic(x509EncodedKeySpec), true);
            String string2 = DERObjectIdentifier.getInstance(ASN1Sequence.getInstance(this._keyEncAlg.getParameters()).getObjectAt(0)).getId();
            SecretKey secretKey = keyAgreement.generateSecret(string2);
            Cipher cipher = Cipher.getInstance(string2, string);
            cipher.init(4, secretKey);
            AlgorithmIdentifier algorithmIdentifier = this._encAlg;
            String string3 = algorithmIdentifier.getObjectId().getId();
            byte[] byArray = this._encryptedKey.getOctets();
            Key key2 = cipher.unwrap(byArray, string3, 3);
            return this.getContentFromSessionKey(key2, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CMSException("originator key spec invalid.", invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (Exception exception) {
            throw new CMSException("originator key invalid.", exception);
        }
    }
}

