/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;

public class JRExpressionCollector {
    private final JRReport report;
    private final JRExpressionCollector parent;
    private Map expressionIds;
    private GeneratedIds generatedIds = new GeneratedIds();
    private Map crosstabIds = new HashMap();
    private Map datasetCollectors;
    private Map crosstabCollectors;
    private final Set collectedStyles;

    public static JRExpressionCollector collector(JRReport jRReport) {
        JRExpressionCollector jRExpressionCollector = new JRExpressionCollector(null, jRReport);
        jRExpressionCollector.collect();
        return jRExpressionCollector;
    }

    public static List collectExpressions(JRReport jRReport) {
        return JRExpressionCollector.collector(jRReport).getExpressions();
    }

    public static JRExpressionCollector collector(JRReport jRReport, JRCrosstab jRCrosstab) {
        JRExpressionCollector jRExpressionCollector = new JRExpressionCollector(null, jRReport);
        jRExpressionCollector.collect(jRCrosstab);
        return jRExpressionCollector;
    }

    public static List collectExpressions(JRReport jRReport, JRCrosstab jRCrosstab) {
        return JRExpressionCollector.collector(jRReport, jRCrosstab).getExpressions(jRCrosstab);
    }

    protected JRExpressionCollector(JRExpressionCollector jRExpressionCollector, JRReport jRReport) {
        this.parent = jRExpressionCollector;
        this.report = jRReport;
        if (jRExpressionCollector == null) {
            this.expressionIds = new HashMap();
            this.datasetCollectors = new HashMap();
            this.crosstabCollectors = new HashMap();
        }
        this.collectedStyles = new HashSet();
    }

    private void addExpression(JRExpression jRExpression) {
        if (jRExpression != null) {
            Integer n = this.getGlobalGeneratedId(jRExpression);
            if (n == null) {
                n = this.generatedIds.nextId();
                this.setGlobalGeneratedId(jRExpression, n);
                this.generatedIds.put(n, jRExpression);
            } else {
                JRExpression jRExpression2 = this.generatedIds.put(n, jRExpression);
                if (jRExpression2 != null && !jRExpression2.equals(jRExpression)) {
                    Integer n2 = this.generatedIds.nextId();
                    this.updateGlobalGeneratedId(jRExpression2, n, n2);
                    this.generatedIds.put(n2, jRExpression2);
                }
            }
        }
    }

    private Integer getGlobalGeneratedId(JRExpression jRExpression) {
        Integer n = this.parent == null ? (Integer)this.expressionIds.get(jRExpression) : this.parent.getGlobalGeneratedId(jRExpression);
        return n;
    }

    private void setGlobalGeneratedId(JRExpression jRExpression, Integer n) {
        if (this.parent == null) {
            Integer n2 = this.expressionIds.put(jRExpression, n);
            if (n2 != null && !((Object)n2).equals(n)) {
                throw new JRRuntimeException("Expression \"" + jRExpression.getText() + "\" has two generated IDs");
            }
        } else {
            this.parent.setGlobalGeneratedId(jRExpression, n);
        }
    }

    private void updateGlobalGeneratedId(JRExpression jRExpression, Integer n, Integer n2) {
        if (this.parent == null) {
            Integer n3 = this.expressionIds.put(jRExpression, n2);
            if (n3 == null || !((Object)n3).equals(n)) {
                throw new JRRuntimeException("Expression \"" + jRExpression.getText() + "\" not found with id " + n);
            }
        } else {
            this.parent.updateGlobalGeneratedId(jRExpression, n, n2);
        }
    }

    private JRExpressionCollector getCollector(JRElementDataset jRElementDataset) {
        JRDatasetRun jRDatasetRun = jRElementDataset.getDatasetRun();
        JRExpressionCollector jRExpressionCollector = jRDatasetRun == null ? this : this.getDatasetCollector(jRDatasetRun.getDatasetName());
        return jRExpressionCollector;
    }

    private JRExpressionCollector getDatasetCollector(String string) {
        JRExpressionCollector jRExpressionCollector = (JRExpressionCollector)this.datasetCollectors.get(string);
        if (jRExpressionCollector == null) {
            jRExpressionCollector = new JRExpressionCollector(this, this.report);
            this.datasetCollectors.put(string, jRExpressionCollector);
        }
        return jRExpressionCollector;
    }

    private JRExpressionCollector getCollector(JRDataset jRDataset) {
        JRExpressionCollector jRExpressionCollector = jRDataset.isMainDataset() || this.datasetCollectors == null ? this : this.getDatasetCollector(jRDataset.getName());
        return jRExpressionCollector;
    }

    private JRExpressionCollector getCollector(JRCrosstab jRCrosstab) {
        JRExpressionCollector jRExpressionCollector = (JRExpressionCollector)this.crosstabCollectors.get(jRCrosstab);
        if (jRExpressionCollector == null) {
            jRExpressionCollector = new JRExpressionCollector(this, this.report);
            this.crosstabCollectors.put(jRCrosstab, jRExpressionCollector);
        }
        return jRExpressionCollector;
    }

    public List getExpressions() {
        return new ArrayList(this.generatedIds.expressions());
    }

    public List getExpressions(JRDataset jRDataset) {
        return this.getCollector(jRDataset).getExpressions();
    }

    public List getExpressions(JRCrosstab jRCrosstab) {
        return this.getCollector(jRCrosstab).getExpressions();
    }

    public Integer getExpressionId(JRExpression jRExpression) {
        return (Integer)this.expressionIds.get(jRExpression);
    }

    public Integer getCrosstabId(JRCrosstab jRCrosstab) {
        return (Integer)this.crosstabIds.get(jRCrosstab);
    }

    public Collection collect() {
        this.collect(this.report.getDefaultStyle());
        this.collect(this.report.getMainDataset());
        JRDataset[] jRDatasetArray = this.report.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            int n = 0;
            while (n < jRDatasetArray.length) {
                JRExpressionCollector jRExpressionCollector = this.getCollector(jRDatasetArray[n]);
                jRExpressionCollector.collect(jRDatasetArray[n]);
                ++n;
            }
        }
        this.collect(this.report.getBackground());
        this.collect(this.report.getTitle());
        this.collect(this.report.getPageHeader());
        this.collect(this.report.getColumnHeader());
        this.collect(this.report.getDetail());
        this.collect(this.report.getColumnFooter());
        this.collect(this.report.getPageFooter());
        this.collect(this.report.getLastPageFooter());
        this.collect(this.report.getSummary());
        return this.getExpressions();
    }

    private void collect(JRStyle jRStyle) {
        if (jRStyle != null && this.collectedStyles.add(jRStyle)) {
            JRConditionalStyle[] jRConditionalStyleArray = jRStyle.getConditionalStyles();
            if (jRConditionalStyleArray != null && jRConditionalStyleArray.length > 0) {
                int n = 0;
                while (n < jRConditionalStyleArray.length) {
                    this.addExpression(jRConditionalStyleArray[n].getConditionExpression());
                    ++n;
                }
            }
            this.collect(jRStyle.getStyle());
        }
    }

    private void collect(JRParameter[] jRParameterArray) {
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            int n = 0;
            while (n < jRParameterArray.length) {
                this.addExpression(jRParameterArray[n].getDefaultValueExpression());
                ++n;
            }
        }
    }

    private void collect(JRVariable[] jRVariableArray) {
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            int n = 0;
            while (n < jRVariableArray.length) {
                JRVariable jRVariable = jRVariableArray[n];
                this.addExpression(jRVariable.getExpression());
                this.addExpression(jRVariable.getInitialValueExpression());
                ++n;
            }
        }
    }

    private void collect(JRGroup[] jRGroupArray) {
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            int n = 0;
            while (n < jRGroupArray.length) {
                JRGroup jRGroup = jRGroupArray[n];
                this.addExpression(jRGroup.getExpression());
                this.collect(jRGroup.getGroupHeader());
                this.collect(jRGroup.getGroupFooter());
                ++n;
            }
        }
    }

    private void collect(JRBand jRBand) {
        if (jRBand != null) {
            this.addExpression(jRBand.getPrintWhenExpression());
            JRElement[] jRElementArray = jRBand.getElements();
            if (jRElementArray != null && jRElementArray.length > 0) {
                int n = 0;
                while (n < jRElementArray.length) {
                    jRElementArray[n].collectExpressions(this);
                    ++n;
                }
            }
        }
    }

    private void collectElement(JRElement jRElement) {
        this.collect(jRElement.getStyle());
        this.addExpression(jRElement.getPrintWhenExpression());
    }

    private void collectAnchor(JRAnchor jRAnchor) {
        this.addExpression(jRAnchor.getAnchorNameExpression());
    }

    private void collectHyperlink(JRHyperlink jRHyperlink) {
        if (jRHyperlink != null) {
            this.addExpression(jRHyperlink.getHyperlinkReferenceExpression());
            this.addExpression(jRHyperlink.getHyperlinkAnchorExpression());
            this.addExpression(jRHyperlink.getHyperlinkPageExpression());
            this.addExpression(jRHyperlink.getHyperlinkTooltipExpression());
            JRHyperlinkParameter[] jRHyperlinkParameterArray = jRHyperlink.getHyperlinkParameters();
            if (jRHyperlinkParameterArray != null) {
                int n = 0;
                while (n < jRHyperlinkParameterArray.length) {
                    JRHyperlinkParameter jRHyperlinkParameter = jRHyperlinkParameterArray[n];
                    this.collectHyperlinkParameter(jRHyperlinkParameter);
                    ++n;
                }
            }
        }
    }

    protected void collectHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        if (jRHyperlinkParameter != null) {
            this.addExpression(jRHyperlinkParameter.getValueExpression());
        }
    }

    public void collect(JRLine jRLine) {
        this.collectElement(jRLine);
    }

    public void collect(JRRectangle jRRectangle) {
        this.collectElement(jRRectangle);
    }

    public void collect(JREllipse jREllipse) {
        this.collectElement(jREllipse);
    }

    public void collect(JRImage jRImage) {
        this.collectElement(jRImage);
        this.addExpression(jRImage.getExpression());
        this.collectAnchor(jRImage);
        this.collectHyperlink(jRImage);
    }

    public void collect(JRStaticText jRStaticText) {
        this.collectElement(jRStaticText);
    }

    public void collect(JRTextField jRTextField) {
        this.collectElement(jRTextField);
        this.addExpression(jRTextField.getExpression());
        this.collectAnchor(jRTextField);
        this.collectHyperlink(jRTextField);
    }

    public void collect(JRSubreport jRSubreport) {
        this.collectElement(jRSubreport);
        this.addExpression(jRSubreport.getParametersMapExpression());
        JRSubreportParameter[] jRSubreportParameterArray = jRSubreport.getParameters();
        if (jRSubreportParameterArray != null && jRSubreportParameterArray.length > 0) {
            int n = 0;
            while (n < jRSubreportParameterArray.length) {
                this.addExpression(jRSubreportParameterArray[n].getExpression());
                ++n;
            }
        }
        this.addExpression(jRSubreport.getConnectionExpression());
        this.addExpression(jRSubreport.getDataSourceExpression());
        this.addExpression(jRSubreport.getExpression());
    }

    public void collect(JRChart jRChart) {
        this.collectElement(jRChart);
        this.collectAnchor(jRChart);
        this.collectHyperlink(jRChart);
        this.addExpression(jRChart.getTitleExpression());
        this.addExpression(jRChart.getSubtitleExpression());
        jRChart.getDataset().collectExpressions(this);
        jRChart.getPlot().collectExpressions(this);
    }

    public void collect(JRPieDataset jRPieDataset) {
        this.collect((JRElementDataset)jRPieDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRPieDataset);
        jRExpressionCollector.addExpression(jRPieDataset.getKeyExpression());
        jRExpressionCollector.addExpression(jRPieDataset.getValueExpression());
        jRExpressionCollector.addExpression(jRPieDataset.getLabelExpression());
        jRExpressionCollector.collectHyperlink(jRPieDataset.getSectionHyperlink());
    }

    public void collect(JRCategoryDataset jRCategoryDataset) {
        this.collect((JRElementDataset)jRCategoryDataset);
        JRCategorySeries[] jRCategorySeriesArray = jRCategoryDataset.getSeries();
        if (jRCategorySeriesArray != null && jRCategorySeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRCategoryDataset);
            int n = 0;
            while (n < jRCategorySeriesArray.length) {
                jRExpressionCollector.collect(jRCategorySeriesArray[n]);
                ++n;
            }
        }
    }

    public void collect(JRXyDataset jRXyDataset) {
        this.collect((JRElementDataset)jRXyDataset);
        JRXySeries[] jRXySeriesArray = jRXyDataset.getSeries();
        if (jRXySeriesArray != null && jRXySeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRXyDataset);
            int n = 0;
            while (n < jRXySeriesArray.length) {
                jRExpressionCollector.collect(jRXySeriesArray[n]);
                ++n;
            }
        }
    }

    public void collect(JRTimeSeriesDataset jRTimeSeriesDataset) {
        this.collect((JRElementDataset)jRTimeSeriesDataset);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRTimeSeriesDataset);
            int n = 0;
            while (n < jRTimeSeriesArray.length) {
                jRExpressionCollector.collect(jRTimeSeriesArray[n]);
                ++n;
            }
        }
    }

    public void collect(JRTimePeriodDataset jRTimePeriodDataset) {
        this.collect((JRElementDataset)jRTimePeriodDataset);
        JRTimePeriodSeries[] jRTimePeriodSeriesArray = jRTimePeriodDataset.getSeries();
        if (jRTimePeriodSeriesArray != null && jRTimePeriodSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRTimePeriodDataset);
            int n = 0;
            while (n < jRTimePeriodSeriesArray.length) {
                jRExpressionCollector.collect(jRTimePeriodSeriesArray[n]);
                ++n;
            }
        }
    }

    public void collect(JRValueDataset jRValueDataset) {
        this.collect((JRElementDataset)jRValueDataset);
        this.addExpression(jRValueDataset.getValueExpression());
    }

    private void collect(JRXySeries jRXySeries) {
        this.addExpression(jRXySeries.getSeriesExpression());
        this.addExpression(jRXySeries.getXValueExpression());
        this.addExpression(jRXySeries.getYValueExpression());
        this.addExpression(jRXySeries.getLabelExpression());
        this.collectHyperlink(jRXySeries.getItemHyperlink());
    }

    private void collect(JRCategorySeries jRCategorySeries) {
        this.addExpression(jRCategorySeries.getSeriesExpression());
        this.addExpression(jRCategorySeries.getCategoryExpression());
        this.addExpression(jRCategorySeries.getValueExpression());
        this.addExpression(jRCategorySeries.getLabelExpression());
        this.collectHyperlink(jRCategorySeries.getItemHyperlink());
    }

    public void collect(JRBarPlot jRBarPlot) {
        this.addExpression(jRBarPlot.getCategoryAxisLabelExpression());
        this.addExpression(jRBarPlot.getValueAxisLabelExpression());
    }

    public void collect(JRBar3DPlot jRBar3DPlot) {
        this.addExpression(jRBar3DPlot.getCategoryAxisLabelExpression());
        this.addExpression(jRBar3DPlot.getValueAxisLabelExpression());
    }

    public void collect(JRLinePlot jRLinePlot) {
        this.addExpression(jRLinePlot.getCategoryAxisLabelExpression());
        this.addExpression(jRLinePlot.getValueAxisLabelExpression());
    }

    public void collect(JRTimeSeriesPlot jRTimeSeriesPlot) {
        this.addExpression(jRTimeSeriesPlot.getTimeAxisLabelExpression());
        this.addExpression(jRTimeSeriesPlot.getValueAxisLabelExpression());
    }

    public void collect(JRScatterPlot jRScatterPlot) {
        this.addExpression(jRScatterPlot.getXAxisLabelExpression());
        this.addExpression(jRScatterPlot.getYAxisLabelExpression());
    }

    public void collect(JRAreaPlot jRAreaPlot) {
        this.addExpression(jRAreaPlot.getCategoryAxisLabelExpression());
        this.addExpression(jRAreaPlot.getValueAxisLabelExpression());
    }

    private void collect(JRTimeSeries jRTimeSeries) {
        this.addExpression(jRTimeSeries.getSeriesExpression());
        this.addExpression(jRTimeSeries.getTimePeriodExpression());
        this.addExpression(jRTimeSeries.getValueExpression());
        this.addExpression(jRTimeSeries.getLabelExpression());
        this.collectHyperlink(jRTimeSeries.getItemHyperlink());
    }

    private void collect(JRTimePeriodSeries jRTimePeriodSeries) {
        this.addExpression(jRTimePeriodSeries.getSeriesExpression());
        this.addExpression(jRTimePeriodSeries.getStartDateExpression());
        this.addExpression(jRTimePeriodSeries.getEndDateExpression());
        this.addExpression(jRTimePeriodSeries.getValueExpression());
        this.addExpression(jRTimePeriodSeries.getLabelExpression());
        this.collectHyperlink(jRTimePeriodSeries.getItemHyperlink());
    }

    public void collect(JRXyzDataset jRXyzDataset) {
        this.collect((JRElementDataset)jRXyzDataset);
        JRXyzSeries[] jRXyzSeriesArray = jRXyzDataset.getSeries();
        if (jRXyzSeriesArray != null && jRXyzSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRXyzDataset);
            int n = 0;
            while (n < jRXyzSeriesArray.length) {
                jRExpressionCollector.collect(jRXyzSeriesArray[n]);
                ++n;
            }
        }
    }

    private void collect(JRXyzSeries jRXyzSeries) {
        this.addExpression(jRXyzSeries.getSeriesExpression());
        this.addExpression(jRXyzSeries.getXValueExpression());
        this.addExpression(jRXyzSeries.getYValueExpression());
        this.addExpression(jRXyzSeries.getZValueExpression());
        this.collectHyperlink(jRXyzSeries.getItemHyperlink());
    }

    public void collect(JRBubblePlot jRBubblePlot) {
        this.addExpression(jRBubblePlot.getXAxisLabelExpression());
        this.addExpression(jRBubblePlot.getYAxisLabelExpression());
    }

    public void collect(JRHighLowPlot jRHighLowPlot) {
        this.addExpression(jRHighLowPlot.getTimeAxisLabelExpression());
        this.addExpression(jRHighLowPlot.getValueAxisLabelExpression());
    }

    public void collect(JRDataRange jRDataRange) {
        if (jRDataRange != null) {
            this.addExpression(jRDataRange.getLowExpression());
            this.addExpression(jRDataRange.getHighExpression());
        }
    }

    public void collect(JRMeterPlot jRMeterPlot) {
        List list = jRMeterPlot.getIntervals();
        if (list != null) {
            for (JRMeterInterval jRMeterInterval : list) {
                this.collect(jRMeterInterval.getDataRange());
            }
        }
        this.collect(jRMeterPlot.getDataRange());
    }

    public void collect(JRThermometerPlot jRThermometerPlot) {
        this.collect(jRThermometerPlot.getDataRange());
        this.collect(jRThermometerPlot.getLowRange());
        this.collect(jRThermometerPlot.getMediumRange());
        this.collect(jRThermometerPlot.getHighRange());
    }

    public void collect(JRHighLowDataset jRHighLowDataset) {
        this.collect((JRElementDataset)jRHighLowDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRHighLowDataset);
        jRExpressionCollector.addExpression(jRHighLowDataset.getSeriesExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getDateExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getHighExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getLowExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getOpenExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getCloseExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getVolumeExpression());
        jRExpressionCollector.collectHyperlink(jRHighLowDataset.getItemHyperlink());
    }

    public void collect(JRCandlestickPlot jRCandlestickPlot) {
        this.addExpression(jRCandlestickPlot.getTimeAxisLabelExpression());
        this.addExpression(jRCandlestickPlot.getValueAxisLabelExpression());
    }

    public void collect(JRCrosstab jRCrosstab) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray;
        Object object;
        Object object2;
        this.collectElement(jRCrosstab);
        this.createCrosstabId(jRCrosstab);
        JRCrosstabDataset jRCrosstabDataset = jRCrosstab.getDataset();
        this.collect(jRCrosstabDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRCrosstabDataset);
        JRExpressionCollector jRExpressionCollector2 = this.getCollector(jRCrosstab);
        jRExpressionCollector2.collect(this.report.getDefaultStyle());
        this.addExpression(jRCrosstab.getParametersMapExpression());
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        if (jRCrosstabParameterArray != null) {
            int n = 0;
            while (n < jRCrosstabParameterArray.length) {
                this.addExpression(jRCrosstabParameterArray[n].getExpression());
                ++n;
            }
        }
        jRExpressionCollector2.collect(jRCrosstab.getHeaderCell());
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray != null) {
            int n = 0;
            while (n < jRCrosstabRowGroupArray.length) {
                object2 = jRCrosstabRowGroupArray[n];
                object = object2.getBucket();
                jRExpressionCollector.addExpression(object.getExpression());
                this.addExpression(object.getComparatorExpression());
                jRExpressionCollector2.collect(object2.getHeader());
                jRExpressionCollector2.collect(object2.getTotalHeader());
                ++n;
            }
        }
        if ((jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups()) != null) {
            int n = 0;
            while (n < jRCrosstabColumnGroupArray.length) {
                object = jRCrosstabColumnGroupArray[n];
                jRExpressionCollector.addExpression(object.getBucket().getExpression());
                this.addExpression(object.getBucket().getComparatorExpression());
                jRExpressionCollector2.collect(object.getHeader());
                jRExpressionCollector2.collect(object.getTotalHeader());
                ++n;
            }
        }
        if ((object2 = jRCrosstab.getMeasures()) != null) {
            int n = 0;
            while (n < ((Object)object2).length) {
                jRExpressionCollector.addExpression(object2[n].getValueExpression());
                ++n;
            }
        }
        jRExpressionCollector2.collect(jRCrosstab.getWhenNoDataCell());
        this.collectCrosstabCells(jRCrosstab, jRExpressionCollector2);
    }

    private void createCrosstabId(JRCrosstab jRCrosstab) {
        this.crosstabIds.put(jRCrosstab, new Integer(this.crosstabIds.size()));
    }

    private void collectCrosstabCells(JRCrosstab jRCrosstab, JRExpressionCollector jRExpressionCollector) {
        block6: {
            block5: {
                if (!(jRCrosstab instanceof JRDesignCrosstab)) break block5;
                List list = ((JRDesignCrosstab)jRCrosstab).getCellsList();
                if (list == null) break block6;
                for (JRCrosstabCell jRCrosstabCell : list) {
                    jRExpressionCollector.collect(jRCrosstabCell.getContents());
                }
                break block6;
            }
            JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
            if (jRCrosstabCellArray != null) {
                int n = 0;
                while (n < jRCrosstabCellArray.length) {
                    int n2 = 0;
                    while (n2 < jRCrosstabCellArray[n].length) {
                        if (jRCrosstabCellArray[n][n2] != null) {
                            jRExpressionCollector.collect(jRCrosstabCellArray[n][n2].getContents());
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
    }

    public Collection collect(JRDataset jRDataset) {
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRDataset);
        jRExpressionCollector.collect(jRDataset.getParameters());
        jRExpressionCollector.collect(jRDataset.getVariables());
        jRExpressionCollector.collect(jRDataset.getGroups());
        jRExpressionCollector.addExpression(jRDataset.getFilterExpression());
        return this.getExpressions(jRDataset);
    }

    protected void collect(JRElementDataset jRElementDataset) {
        this.collect(jRElementDataset.getDatasetRun());
        JRExpression jRExpression = jRElementDataset.getIncrementWhenExpression();
        if (jRExpression != null) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRElementDataset);
            jRExpressionCollector.addExpression(jRExpression);
        }
    }

    private void collect(JRDatasetRun jRDatasetRun) {
        if (jRDatasetRun != null) {
            this.addExpression(jRDatasetRun.getParametersMapExpression());
            this.addExpression(jRDatasetRun.getConnectionExpression());
            this.addExpression(jRDatasetRun.getDataSourceExpression());
            JRDatasetParameter[] jRDatasetParameterArray = jRDatasetRun.getParameters();
            if (jRDatasetParameterArray != null && jRDatasetParameterArray.length > 0) {
                int n = 0;
                while (n < jRDatasetParameterArray.length) {
                    this.addExpression(jRDatasetParameterArray[n].getExpression());
                    ++n;
                }
            }
        }
    }

    protected void collect(JRCellContents jRCellContents) {
        if (jRCellContents != null) {
            this.collect(jRCellContents.getStyle());
            JRElement[] jRElementArray = jRCellContents.getElements();
            if (jRElementArray != null && jRElementArray.length > 0) {
                int n = 0;
                while (n < jRElementArray.length) {
                    jRElementArray[n].collectExpressions(this);
                    ++n;
                }
            }
        }
    }

    public void collect(JRFrame jRFrame) {
        this.collectElement(jRFrame);
        JRElement[] jRElementArray = jRFrame.getElements();
        if (jRElementArray != null) {
            int n = 0;
            while (n < jRElementArray.length) {
                jRElementArray[n].collectExpressions(this);
                ++n;
            }
        }
    }

    protected static class GeneratedIds {
        private final TreeMap ids = new TreeMap();
        private int nextId = 0;
        private List expressions;

        protected GeneratedIds() {
        }

        public JRExpression put(Integer n, JRExpression jRExpression) {
            this.expressions = null;
            return this.ids.put(n, jRExpression);
        }

        public Integer nextId() {
            Integer n = new Integer(this.nextId);
            while (this.ids.containsKey(n)) {
                n = new Integer(++this.nextId);
            }
            return n;
        }

        public List expressions() {
            if (this.expressions == null) {
                this.expressions = new ArrayList(this.ids.values());
            }
            return this.expressions;
        }
    }
}

