/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class Util
implements SuffixConstants {
    private static final int DEFAULT_READING_SIZE = 8192;
    public static final String UTF_8 = "UTF-8";
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static char[] bytesToChar(byte[] byArray, String string) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(byArray), byArray.length, string);
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block7: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                byArray = Util.getInputStreamAsByteArray(fileInputStream, (int)file.length());
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static char[] getFileCharContent(File file, String string) throws IOException {
        char[] cArray;
        block7: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                cArray = Util.getInputStreamAsCharArray(fileInputStream, (int)file.length(), string);
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream inputStream, int n) throws IOException {
        byte[] byArray;
        if (n == -1) {
            byArray = new byte[]{};
            int n2 = 0;
            int n3 = -1;
            do {
                int n4;
                if (n2 + (n4 = Math.max(inputStream.available(), 8192)) > byArray.length) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[n2 + n4];
                    System.arraycopy(byArray2, 0, byArray, 0, n2);
                }
                if ((n3 = inputStream.read(byArray, n2, n4)) <= 0) continue;
                n2 += n3;
            } while (n3 != -1);
            if (n2 < byArray.length) {
                byte[] byArray3 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray3, 0, byArray, 0, n2);
            }
        } else {
            byArray = new byte[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStream.read(byArray, n5 += n6, n - n5);
            }
        }
        return byArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        int n2;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        int n3 = 0;
        char[] cArray = n == -1 ? CharOperation.NO_CHAR : new char[n];
        while (true) {
            int n4;
            if (n3 < n) {
                n2 = n - n3;
            } else {
                n4 = inputStreamReader.read();
                if (n4 < 0) break;
                n2 = Math.max(inputStream.available(), 8192);
                if (n3 + 1 + n2 > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n3 + 1 + n2];
                    System.arraycopy(cArray2, 0, cArray, 0, n3);
                }
                cArray[n3++] = (char)n4;
            }
            n4 = inputStreamReader.read(cArray, n3, n2);
            if (n4 < 0) break;
            n3 += n4;
        }
        n2 = 0;
        if (n3 > 0 && UTF_8.equals(string) && cArray[0] == '\ufeff') {
            --n3;
            n2 = 1;
        }
        if (n3 < cArray.length) {
            char[] cArray3 = cArray;
            cArray = new char[n3];
            System.arraycopy(cArray3, n2, cArray, 0, n3);
        }
        return cArray;
    }

    public static byte[] getZipEntryByteContent(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        byte[] byArray;
        block8: {
            InputStream inputStream = null;
            try {
                inputStream = zipFile.getInputStream(zipEntry);
                if (inputStream == null) {
                    throw new IOException("Invalid zip entry name : " + zipEntry.getName());
                }
                byArray = Util.getInputStreamAsByteArray(inputStream, (int)zipEntry.getSize());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static final boolean isArchiveFileName(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        if (n2 < (n = SUFFIX_JAR.length)) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4;
            char c = string.charAt(n2 - n3 - 1);
            if (c != SUFFIX_jar[n4 = n - n3 - 1] && c != SUFFIX_JAR[n4]) {
                n = SUFFIX_ZIP.length;
                if (n2 < n) {
                    return false;
                }
                int n5 = 0;
                while (n5 < n) {
                    c = string.charAt(n2 - n5 - 1);
                    if (c != SUFFIX_zip[n4 = n - n5 - 1] && c != SUFFIX_ZIP[n4]) {
                        return false;
                    }
                    ++n5;
                }
                return true;
            }
            ++n3;
        }
        return true;
    }

    public static final boolean isClassFileName(char[] cArray) {
        int n;
        int n2 = cArray == null ? 0 : cArray.length;
        if (n2 < (n = SUFFIX_CLASS.length)) {
            return false;
        }
        int n3 = 0;
        int n4 = n2 - n;
        while (n3 < n) {
            char c = cArray[n4 + n3];
            if (c != SUFFIX_class[n3] && c != SUFFIX_CLASS[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final boolean isClassFileName(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        if (n2 < (n = SUFFIX_CLASS.length)) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4;
            char c = string.charAt(n2 - n3 - 1);
            if (c != SUFFIX_class[n4 = n - n3 - 1] && c != SUFFIX_CLASS[n4]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final boolean isExcluded(char[] cArray, char[][] cArray2, char[][] cArray3, boolean bl) {
        int n;
        int n2;
        block9: {
            if (cArray2 == null && cArray3 == null) {
                return false;
            }
            if (cArray2 != null) {
                n2 = 0;
                n = cArray2.length;
                while (n2 < n) {
                    int n3;
                    int n4;
                    char[] cArray4;
                    char[] cArray5 = cArray4 = cArray2[n2];
                    if (bl && (n4 = CharOperation.lastIndexOf('/', cArray4)) != -1 && n4 != cArray4.length - 1 && ((n3 = CharOperation.indexOf('*', cArray4, n4)) == -1 || n3 >= cArray4.length - 1 || cArray4[n3 + 1] != '*')) {
                        cArray5 = CharOperation.subarray(cArray4, 0, n4);
                    }
                    if (!CharOperation.pathMatch(cArray5, cArray, true, '/')) {
                        ++n2;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (bl) {
            cArray = CharOperation.concat(cArray, new char[]{'*'}, '/');
        }
        if (cArray3 != null) {
            n2 = 0;
            n = cArray3.length;
            while (n2 < n) {
                if (CharOperation.pathMatch(cArray3[n2], cArray, true, '/')) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static final boolean isJavaFileName(char[] cArray) {
        int n;
        int n2 = cArray == null ? 0 : cArray.length;
        if (n2 < (n = SUFFIX_JAVA.length)) {
            return false;
        }
        int n3 = 0;
        int n4 = n2 - n;
        while (n3 < n) {
            char c = cArray[n4 + n3];
            if (c != SUFFIX_java[n3] && c != SUFFIX_JAVA[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final boolean isJavaFileName(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        if (n2 < (n = SUFFIX_JAVA.length)) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4;
            char c = string.charAt(n2 - n3 - 1);
            if (c != SUFFIX_java[n4 = n - n3 - 1] && c != SUFFIX_JAVA[n4]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final int searchLineNumber(int[] nArray, int n) {
        if (nArray == null) {
            return 1;
        }
        int n2 = nArray.length;
        if (n2 == 0) {
            return 1;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = (n3 + n4) / 2;
            int n6 = nArray[n5];
            if (n < n6) {
                n4 = n5 - 1;
                continue;
            }
            if (n > n6) {
                n3 = n5 + 1;
                continue;
            }
            return n5 + 1;
        }
        if (n < nArray[n5]) {
            return n5 + 1;
        }
        return n5 + 2;
    }

    public static final int searchColumnNumber(int[] nArray, int n, int n2) {
        switch (n) {
            case 1: {
                return n2 + 1;
            }
            case 2: {
                return n2 - nArray[0];
            }
        }
        int n3 = n - 2;
        int n4 = nArray.length;
        if (n3 >= n4) {
            return n2 - nArray[n4 - 1];
        }
        return n2 - nArray[n3];
    }

    public static Boolean toBoolean(boolean bl) {
        if (bl) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String toString(Object[] objectArray) {
        return Util.toString(objectArray, new Displayable(){

            public String displayString(Object object) {
                if (object == null) {
                    return "null";
                }
                return object.toString();
            }
        });
    }

    public static String toString(Object[] objectArray, Displayable displayable) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(displayable.displayString(objectArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

