/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.wmf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.codec.BmpImage;
import com.lowagie.text.pdf.codec.wmf.InputMeta;
import com.lowagie.text.pdf.codec.wmf.MetaBrush;
import com.lowagie.text.pdf.codec.wmf.MetaFont;
import com.lowagie.text.pdf.codec.wmf.MetaObject;
import com.lowagie.text.pdf.codec.wmf.MetaPen;
import com.lowagie.text.pdf.codec.wmf.MetaState;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MetaDo {
    public static final int META_SETBKCOLOR = 513;
    public static final int META_SETBKMODE = 258;
    public static final int META_SETMAPMODE = 259;
    public static final int META_SETROP2 = 260;
    public static final int META_SETRELABS = 261;
    public static final int META_SETPOLYFILLMODE = 262;
    public static final int META_SETSTRETCHBLTMODE = 263;
    public static final int META_SETTEXTCHAREXTRA = 264;
    public static final int META_SETTEXTCOLOR = 521;
    public static final int META_SETTEXTJUSTIFICATION = 522;
    public static final int META_SETWINDOWORG = 523;
    public static final int META_SETWINDOWEXT = 524;
    public static final int META_SETVIEWPORTORG = 525;
    public static final int META_SETVIEWPORTEXT = 526;
    public static final int META_OFFSETWINDOWORG = 527;
    public static final int META_SCALEWINDOWEXT = 1040;
    public static final int META_OFFSETVIEWPORTORG = 529;
    public static final int META_SCALEVIEWPORTEXT = 1042;
    public static final int META_LINETO = 531;
    public static final int META_MOVETO = 532;
    public static final int META_EXCLUDECLIPRECT = 1045;
    public static final int META_INTERSECTCLIPRECT = 1046;
    public static final int META_ARC = 2071;
    public static final int META_ELLIPSE = 1048;
    public static final int META_FLOODFILL = 1049;
    public static final int META_PIE = 2074;
    public static final int META_RECTANGLE = 1051;
    public static final int META_ROUNDRECT = 1564;
    public static final int META_PATBLT = 1565;
    public static final int META_SAVEDC = 30;
    public static final int META_SETPIXEL = 1055;
    public static final int META_OFFSETCLIPRGN = 544;
    public static final int META_TEXTOUT = 1313;
    public static final int META_BITBLT = 2338;
    public static final int META_STRETCHBLT = 2851;
    public static final int META_POLYGON = 804;
    public static final int META_POLYLINE = 805;
    public static final int META_ESCAPE = 1574;
    public static final int META_RESTOREDC = 295;
    public static final int META_FILLREGION = 552;
    public static final int META_FRAMEREGION = 1065;
    public static final int META_INVERTREGION = 298;
    public static final int META_PAINTREGION = 299;
    public static final int META_SELECTCLIPREGION = 300;
    public static final int META_SELECTOBJECT = 301;
    public static final int META_SETTEXTALIGN = 302;
    public static final int META_CHORD = 2096;
    public static final int META_SETMAPPERFLAGS = 561;
    public static final int META_EXTTEXTOUT = 2610;
    public static final int META_SETDIBTODEV = 3379;
    public static final int META_SELECTPALETTE = 564;
    public static final int META_REALIZEPALETTE = 53;
    public static final int META_ANIMATEPALETTE = 1078;
    public static final int META_SETPALENTRIES = 55;
    public static final int META_POLYPOLYGON = 1336;
    public static final int META_RESIZEPALETTE = 313;
    public static final int META_DIBBITBLT = 2368;
    public static final int META_DIBSTRETCHBLT = 2881;
    public static final int META_DIBCREATEPATTERNBRUSH = 322;
    public static final int META_STRETCHDIB = 3907;
    public static final int META_EXTFLOODFILL = 1352;
    public static final int META_DELETEOBJECT = 496;
    public static final int META_CREATEPALETTE = 247;
    public static final int META_CREATEPATTERNBRUSH = 505;
    public static final int META_CREATEPENINDIRECT = 762;
    public static final int META_CREATEFONTINDIRECT = 763;
    public static final int META_CREATEBRUSHINDIRECT = 764;
    public static final int META_CREATEREGION = 1791;
    public PdfContentByte cb;
    public InputMeta in;
    int left;
    int top;
    int right;
    int bottom;
    int inch;
    MetaState state = new MetaState();

    public MetaDo(InputStream inputStream, PdfContentByte pdfContentByte) {
        this.cb = pdfContentByte;
        this.in = new InputMeta(inputStream);
    }

    public void readAll() throws IOException, DocumentException {
        if (this.in.readInt() != -1698247209) {
            throw new DocumentException("Not a placeable windows metafile");
        }
        this.in.readWord();
        this.left = this.in.readShort();
        this.top = this.in.readShort();
        this.right = this.in.readShort();
        this.bottom = this.in.readShort();
        this.inch = this.in.readWord();
        this.state.setScalingX((float)(this.right - this.left) / (float)this.inch * 72.0f);
        this.state.setScalingY((float)(this.bottom - this.top) / (float)this.inch * 72.0f);
        this.state.setOffsetWx(this.left);
        this.state.setOffsetWy(this.top);
        this.state.setExtentWx(this.right - this.left);
        this.state.setExtentWy(this.bottom - this.top);
        this.in.readInt();
        this.in.readWord();
        this.in.skip(18);
        this.cb.setLineCap(1);
        this.cb.setLineJoin(1);
        while (true) {
            int n = this.in.getLength();
            int n2 = this.in.readInt();
            if (n2 < 3) break;
            int n3 = this.in.readWord();
            switch (n3) {
                case 0: {
                    break;
                }
                case 247: 
                case 322: 
                case 1791: {
                    this.state.addMetaObject(new MetaObject());
                    break;
                }
                case 762: {
                    MetaPen metaPen = new MetaPen();
                    metaPen.init(this.in);
                    this.state.addMetaObject(metaPen);
                    break;
                }
                case 764: {
                    MetaBrush metaBrush = new MetaBrush();
                    metaBrush.init(this.in);
                    this.state.addMetaObject(metaBrush);
                    break;
                }
                case 763: {
                    MetaFont metaFont = new MetaFont();
                    metaFont.init(this.in);
                    this.state.addMetaObject(metaFont);
                    break;
                }
                case 301: {
                    int n4 = this.in.readWord();
                    this.state.selectMetaObject(n4, this.cb);
                    break;
                }
                case 496: {
                    int n5 = this.in.readWord();
                    this.state.deleteMetaObject(n5);
                    break;
                }
                case 30: {
                    this.state.saveState(this.cb);
                    break;
                }
                case 295: {
                    int n6 = this.in.readShort();
                    this.state.restoreState(n6, this.cb);
                    break;
                }
                case 523: {
                    this.state.setOffsetWy(this.in.readShort());
                    this.state.setOffsetWx(this.in.readShort());
                    break;
                }
                case 524: {
                    this.state.setExtentWy(this.in.readShort());
                    this.state.setExtentWx(this.in.readShort());
                    break;
                }
                case 532: {
                    int n7 = this.in.readShort();
                    Point point = new Point(this.in.readShort(), n7);
                    this.state.setCurrentPoint(point);
                    break;
                }
                case 531: {
                    int n8 = this.in.readShort();
                    int n9 = this.in.readShort();
                    Point point = this.state.getCurrentPoint();
                    this.cb.moveTo(this.state.transformX(point.x), this.state.transformY(point.y));
                    this.cb.lineTo(this.state.transformX(n9), this.state.transformY(n8));
                    this.cb.stroke();
                    this.state.setCurrentPoint(new Point(n9, n8));
                    break;
                }
                case 805: {
                    this.state.setLineJoinPolygon(this.cb);
                    int n10 = this.in.readWord();
                    int n11 = this.in.readShort();
                    int n12 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n11), this.state.transformY(n12));
                    int n13 = 1;
                    while (n13 < n10) {
                        n11 = this.in.readShort();
                        n12 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n11), this.state.transformY(n12));
                        ++n13;
                    }
                    this.cb.stroke();
                    break;
                }
                case 804: {
                    if (this.isNullStrokeFill(false)) break;
                    int n14 = this.in.readWord();
                    int n15 = this.in.readShort();
                    int n16 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n15), this.state.transformY(n16));
                    int n17 = 1;
                    while (n17 < n14) {
                        int n18 = this.in.readShort();
                        int n19 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n18), this.state.transformY(n19));
                        ++n17;
                    }
                    this.cb.lineTo(this.state.transformX(n15), this.state.transformY(n16));
                    this.strokeAndFill();
                    break;
                }
                case 1336: {
                    int n20;
                    if (this.isNullStrokeFill(false)) break;
                    int n21 = this.in.readWord();
                    int[] nArray = new int[n21];
                    int n22 = 0;
                    while (n22 < nArray.length) {
                        nArray[n22] = this.in.readWord();
                        ++n22;
                    }
                    n22 = 0;
                    while (n22 < nArray.length) {
                        int n23 = nArray[n22];
                        int n24 = this.in.readShort();
                        int n25 = this.in.readShort();
                        this.cb.moveTo(this.state.transformX(n24), this.state.transformY(n25));
                        int n26 = 1;
                        while (n26 < n23) {
                            n20 = this.in.readShort();
                            int n27 = this.in.readShort();
                            this.cb.lineTo(this.state.transformX(n20), this.state.transformY(n27));
                            ++n26;
                        }
                        this.cb.lineTo(this.state.transformX(n24), this.state.transformY(n25));
                        ++n22;
                    }
                    this.strokeAndFill();
                    break;
                }
                case 1048: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    int n28 = this.in.readShort();
                    int n29 = this.in.readShort();
                    int n30 = this.in.readShort();
                    int n31 = this.in.readShort();
                    this.cb.arc(this.state.transformX(n31), this.state.transformY(n28), this.state.transformX(n29), this.state.transformY(n30), 0.0f, 360.0f);
                    this.strokeAndFill();
                    break;
                }
                case 2071: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f2 = this.state.transformX(this.in.readShort());
                    float f3 = this.state.transformY(this.in.readShort());
                    float f4 = this.state.transformX(this.in.readShort());
                    float f5 = this.state.transformY(this.in.readShort());
                    float f6 = this.state.transformX(this.in.readShort());
                    float f7 = this.state.transformY(this.in.readShort());
                    float f8 = this.state.transformX(this.in.readShort());
                    float f9 = (f6 + f8) / 2.0f;
                    float f10 = (f7 + f5) / 2.0f;
                    float f11 = MetaDo.getArc(f9, f10, f4, f3);
                    float f12 = MetaDo.getArc(f9, f10, f2, f);
                    if ((f12 -= f11) <= 0.0f) {
                        f12 += 360.0f;
                    }
                    this.cb.arc(f8, f5, f6, f7, f11, f12);
                    this.cb.stroke();
                    break;
                }
                case 2074: {
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f13 = this.state.transformX(this.in.readShort());
                    float f14 = this.state.transformY(this.in.readShort());
                    float f15 = this.state.transformX(this.in.readShort());
                    float f16 = this.state.transformY(this.in.readShort());
                    float f17 = this.state.transformX(this.in.readShort());
                    float f18 = this.state.transformY(this.in.readShort());
                    float f19 = this.state.transformX(this.in.readShort());
                    float f20 = (f17 + f19) / 2.0f;
                    float f21 = (f18 + f16) / 2.0f;
                    float f22 = MetaDo.getArc(f20, f21, f15, f14);
                    float f12 = MetaDo.getArc(f20, f21, f13, f);
                    if ((f12 -= f22) <= 0.0f) {
                        f12 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f19, f16, f17, f18, f22, f12)).isEmpty()) break;
                    float[] fArray = (float[])arrayList.get(0);
                    this.cb.moveTo(f20, f21);
                    this.cb.lineTo(fArray[0], fArray[1]);
                    int n32 = 0;
                    while (n32 < arrayList.size()) {
                        fArray = (float[])arrayList.get(n32);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                        ++n32;
                    }
                    this.cb.lineTo(f20, f21);
                    this.strokeAndFill();
                    break;
                }
                case 2096: {
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f23 = this.state.transformX(this.in.readShort());
                    float f24 = this.state.transformY(this.in.readShort());
                    float f25 = this.state.transformX(this.in.readShort());
                    float f26 = this.state.transformY(this.in.readShort());
                    float f27 = this.state.transformX(this.in.readShort());
                    float f28 = this.state.transformY(this.in.readShort());
                    float f29 = this.state.transformX(this.in.readShort());
                    float f30 = (f27 + f29) / 2.0f;
                    float f31 = (f28 + f26) / 2.0f;
                    float f32 = MetaDo.getArc(f30, f31, f25, f24);
                    float f12 = MetaDo.getArc(f30, f31, f23, f);
                    if ((f12 -= f32) <= 0.0f) {
                        f12 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f29, f26, f27, f28, f32, f12)).isEmpty()) break;
                    float[] fArray = (float[])arrayList.get(0);
                    f30 = fArray[0];
                    f31 = fArray[1];
                    this.cb.moveTo(f30, f31);
                    int n32 = 0;
                    while (n32 < arrayList.size()) {
                        fArray = (float[])arrayList.get(n32);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                        ++n32;
                    }
                    this.cb.lineTo(f30, f31);
                    this.strokeAndFill();
                    break;
                }
                case 1051: {
                    if (this.isNullStrokeFill(true)) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f33 = this.state.transformX(this.in.readShort());
                    float f34 = this.state.transformY(this.in.readShort());
                    float f35 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f35, f, f33 - f35, f34 - f);
                    this.strokeAndFill();
                    break;
                }
                case 1564: {
                    if (this.isNullStrokeFill(true)) break;
                    float f = this.state.transformY(0) - this.state.transformY(this.in.readShort());
                    float f36 = this.state.transformX(this.in.readShort()) - this.state.transformX(0);
                    float f37 = this.state.transformY(this.in.readShort());
                    float f38 = this.state.transformX(this.in.readShort());
                    float f39 = this.state.transformY(this.in.readShort());
                    float f40 = this.state.transformX(this.in.readShort());
                    this.cb.roundRectangle(f40, f37, f38 - f40, f39 - f37, (f + f36) / 4.0f);
                    this.strokeAndFill();
                    break;
                }
                case 1046: {
                    float f = this.state.transformY(this.in.readShort());
                    float f41 = this.state.transformX(this.in.readShort());
                    float f42 = this.state.transformY(this.in.readShort());
                    float f43 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f43, f, f41 - f43, f42 - f);
                    this.cb.eoClip();
                    this.cb.newPath();
                    break;
                }
                case 2610: {
                    String string;
                    int n33 = this.in.readShort();
                    int n34 = this.in.readShort();
                    int n35 = this.in.readWord();
                    int n36 = this.in.readWord();
                    int n37 = 0;
                    int n38 = 0;
                    int n39 = 0;
                    int n20 = 0;
                    if ((n36 & 6) != 0) {
                        n37 = this.in.readShort();
                        n38 = this.in.readShort();
                        n39 = this.in.readShort();
                        n20 = this.in.readShort();
                    }
                    byte[] byArray = new byte[n35];
                    int n40 = 0;
                    while (n40 < n35) {
                        byte by = (byte)this.in.readByte();
                        if (by == 0) break;
                        byArray[n40] = by;
                        ++n40;
                    }
                    try {
                        string = new String(byArray, 0, n40, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n40);
                    }
                    this.outputText(n34, n33, n36, n37, n38, n39, n20, string);
                    break;
                }
                case 1313: {
                    String string;
                    int n41 = this.in.readWord();
                    byte[] byArray = new byte[n41];
                    int n42 = 0;
                    while (n42 < n41) {
                        byte by = (byte)this.in.readByte();
                        if (by == 0) break;
                        byArray[n42] = by;
                        ++n42;
                    }
                    try {
                        string = new String(byArray, 0, n42, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n42);
                    }
                    n41 = n41 + 1 & 0xFFFE;
                    this.in.skip(n41 - n42);
                    int n43 = this.in.readShort();
                    int n44 = this.in.readShort();
                    this.outputText(n44, n43, 0, 0, 0, 0, 0, string);
                    break;
                }
                case 513: {
                    this.state.setCurrentBackgroundColor(this.in.readColor());
                    break;
                }
                case 521: {
                    this.state.setCurrentTextColor(this.in.readColor());
                    break;
                }
                case 302: {
                    this.state.setTextAlign(this.in.readWord());
                    break;
                }
                case 258: {
                    this.state.setBackgroundMode(this.in.readWord());
                    break;
                }
                case 262: {
                    this.state.setPolyFillMode(this.in.readWord());
                    break;
                }
                case 1055: {
                    Color color = this.in.readColor();
                    int n45 = this.in.readShort();
                    int n46 = this.in.readShort();
                    this.cb.saveState();
                    this.cb.setColorFill(color);
                    this.cb.rectangle(this.state.transformX(n46), this.state.transformY(n45), 0.2f, 0.2f);
                    this.cb.fill();
                    this.cb.restoreState();
                    break;
                }
                case 2881: 
                case 3907: {
                    this.in.readInt();
                    if (n3 == 3907) {
                        this.in.readWord();
                    }
                    int n47 = this.in.readShort();
                    int n48 = this.in.readShort();
                    int n49 = this.in.readShort();
                    int n50 = this.in.readShort();
                    float f = this.state.transformY(this.in.readShort()) - this.state.transformY(0);
                    float f44 = this.state.transformX(this.in.readShort()) - this.state.transformX(0);
                    float f45 = this.state.transformY(this.in.readShort());
                    float f46 = this.state.transformX(this.in.readShort());
                    byte[] byArray = new byte[n2 * 2 - (this.in.getLength() - n)];
                    int n51 = 0;
                    while (n51 < byArray.length) {
                        byArray[n51] = (byte)this.in.readByte();
                        ++n51;
                    }
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        Image image = BmpImage.getImage(byteArrayInputStream, true, byArray.length);
                        this.cb.saveState();
                        this.cb.rectangle(f46, f45, f44, f);
                        this.cb.clip();
                        this.cb.newPath();
                        image.scaleAbsolute(f44 * image.width() / (float)n48, -f * image.height() / (float)n47);
                        image.setAbsolutePosition(f46 - f44 * (float)n50 / (float)n48, f45 + f * (float)n49 / (float)n47 - image.scaledHeight());
                        this.cb.addImage(image);
                        this.cb.restoreState();
                        break;
                    }
                    catch (Exception exception) {}
                }
            }
            this.in.skip(n2 * 2 - (this.in.getLength() - n));
        }
        this.state.cleanup(this.cb);
    }

    public void outputText(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        Color color;
        MetaFont metaFont = this.state.getCurrentFont();
        float f = this.state.transformX(n);
        float f2 = this.state.transformY(n2);
        float f3 = this.state.transformAngle(metaFont.getAngle());
        float f4 = (float)Math.sin(f3);
        float f5 = (float)Math.cos(f3);
        float f6 = metaFont.getFontSize(this.state);
        BaseFont baseFont = metaFont.getFont();
        int n8 = this.state.getTextAlign();
        float f7 = baseFont.getWidthPoint(string, f6);
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = baseFont.getFontDescriptor(3, f6);
        float f11 = baseFont.getFontDescriptor(8, f6);
        this.cb.saveState();
        this.cb.concatCTM(f5, f4, -f4, f5, f, f2);
        if ((n8 & 6) == 6) {
            f8 = -f7 / 2.0f;
        } else if ((n8 & 2) == 2) {
            f8 = -f7;
        }
        f9 = (n8 & 0x18) == 24 ? 0.0f : ((n8 & 8) == 8 ? -f10 : -f11);
        if (this.state.getBackgroundMode() == 2) {
            color = this.state.getCurrentBackgroundColor();
            this.cb.setColorFill(color);
            this.cb.rectangle(f8, f9 + f10, f7, f11 - f10);
            this.cb.fill();
        }
        color = this.state.getCurrentTextColor();
        this.cb.setColorFill(color);
        this.cb.beginText();
        this.cb.setFontAndSize(baseFont, f6);
        this.cb.setTextMatrix(f8, f9);
        this.cb.showText(string);
        this.cb.endText();
        if (metaFont.isUnderline()) {
            this.cb.rectangle(f8, f9 - f6 / 4.0f, f7, f6 / 15.0f);
            this.cb.fill();
        }
        if (metaFont.isStrikeout()) {
            this.cb.rectangle(f8, f9 + f6 / 3.0f, f7, f6 / 15.0f);
            this.cb.fill();
        }
        this.cb.restoreState();
    }

    public boolean isNullStrokeFill(boolean bl) {
        boolean bl2;
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        boolean bl3 = metaPen.getStyle() == 5;
        int n = metaBrush.getStyle();
        boolean bl4 = n == 0 || n == 2 && this.state.getBackgroundMode() == 2;
        boolean bl5 = bl2 = bl3 && !bl4;
        if (!bl3) {
            if (bl) {
                this.state.setLineJoinRectangle(this.cb);
            } else {
                this.state.setLineJoinPolygon(this.cb);
            }
        }
        return bl2;
    }

    public void strokeAndFill() {
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        int n = metaPen.getStyle();
        int n2 = metaBrush.getStyle();
        if (n == 5) {
            this.cb.closePath();
            if (this.state.getPolyFillMode() == 1) {
                this.cb.eoFill();
            } else {
                this.cb.fill();
            }
        } else {
            boolean bl;
            boolean bl2 = bl = n2 == 0 || n2 == 2 && this.state.getBackgroundMode() == 2;
            if (bl) {
                if (this.state.getPolyFillMode() == 1) {
                    this.cb.closePathEoFillStroke();
                } else {
                    this.cb.closePathFillStroke();
                }
            } else {
                this.cb.closePathStroke();
            }
        }
    }

    static float getArc(float f, float f2, float f3, float f4) {
        double d = Math.atan2(f4 - f2, f3 - f);
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return (float)(d / Math.PI * 180.0);
    }

    public static byte[] wrapBMP(Image image) throws IOException {
        if (image.getOriginalType() != 4) {
            throw new IOException("Only BMP can be wrapped in WMF.");
        }
        byte[] byArray = null;
        if (image.getOriginalData() == null) {
            InputStream inputStream = image.url().openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            byArray = image.getOriginalData();
        }
        int n = byArray.length - 14 + 1 >>> 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MetaDo.writeWord(byteArrayOutputStream, 1);
        MetaDo.writeWord(byteArrayOutputStream, 9);
        MetaDo.writeWord(byteArrayOutputStream, 768);
        MetaDo.writeDWord(byteArrayOutputStream, 23 + (13 + n) + 3);
        MetaDo.writeWord(byteArrayOutputStream, 1);
        MetaDo.writeDWord(byteArrayOutputStream, 14 + n);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeDWord(byteArrayOutputStream, 4);
        MetaDo.writeWord(byteArrayOutputStream, 259);
        MetaDo.writeWord(byteArrayOutputStream, 8);
        MetaDo.writeDWord(byteArrayOutputStream, 5);
        MetaDo.writeWord(byteArrayOutputStream, 523);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeDWord(byteArrayOutputStream, 5);
        MetaDo.writeWord(byteArrayOutputStream, 524);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.height());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.width());
        MetaDo.writeDWord(byteArrayOutputStream, 13 + n);
        MetaDo.writeWord(byteArrayOutputStream, 2881);
        MetaDo.writeDWord(byteArrayOutputStream, 0xCC0020);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.height());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.width());
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.height());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.width());
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(byArray, 14, byArray.length - 14);
        if ((byArray.length & 1) == 1) {
            byteArrayOutputStream.write(0);
        }
        MetaDo.writeDWord(byteArrayOutputStream, 3);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeWord(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
    }

    public static void writeDWord(OutputStream outputStream, int n) throws IOException {
        MetaDo.writeWord(outputStream, n & 0xFFFF);
        MetaDo.writeWord(outputStream, n >>> 16 & 0xFFFF);
    }
}

