// $Id: MetaException.java,v 1.5 1998/06/08 10:14:11 oliva Exp $

/* Copyright 1997,1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package BR.unicamp.Guarana;

/** This exception encapsulates any Exception that is produced by a
    MetaObject or other objects it invokes while handling an
    Operation.

    @author Alexandre Oliva
    @version $Revision: 1.5 $  */
public class MetaException extends RuntimeException {
  /** The thrown value encapsulated in this Exception.  */
  public final Throwable thrown;

  /** Constructs an MetaException without a detail message.

      @param thrown the Throwable thrown in the meta-level.  */
  public MetaException(Throwable thrown) {
    super();
    this.thrown = thrown;
  }

  /** Constructs an MetaException with a detail message.

      @param thrown the Throwable thrown in the meta-level.

      @param s the detail message.  */
  public MetaException(Throwable thrown, String s) {
    super(s);
    this.thrown = thrown;
  }

  /** Returns the localized detail message of this MetaException.

      @return the optional detail message provided at construction
      time, concatenated with the string that represents the
      encapsulated exception.  */
  public String getLocalizedMessage() {
    final String mymsg = super.getLocalizedMessage(),
	thmsg = thrown.getLocalizedMessage();
    return (mymsg == null ? "" : mymsg + ": ") +
	Guarana.getClassName(Guarana.getClass(thrown)) +
	(thmsg == null ? "" : ": " + thmsg);
  }

  /** Returns the detail message of this MetaException.

      @return the optional detail message provided at construction
      time, concatenated with the string that represents the
      encapsulated exception.  */
  public String getMessage() {
    final String mymsg = super.getMessage(),
	thmsg = thrown.getMessage();
    return (mymsg == null ? "" : mymsg + ": ") +
	Guarana.getClassName(Guarana.getClass(thrown)) + 
	(thmsg == null ? "" : ": " + thmsg);
  }

  /** Obtains the Throwable that was encapsulated in the
      MetaException.

      @return the Throwable.  */
  public Throwable getException() {
    return thrown;
  }
}
