// $Id: Reconfigure.java,v 1.1 1998/05/29 16:07:07 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import BR.unicamp.Guarana.Guarana;

/**
 * This class is used to show that InstanceReconfigure messages are
 * sent to all base classes of an Object.  */
class ReconfigureBase {}

/**
 * This program presents some particular cases of reconfiguration,
 * such as initial reconfiguration in the presence of class
 * meta-configurations, meta-object replacement and removal.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $
 */
public class Reconfigure extends ReconfigureBase {
    public static void main(String[ ] argv) {
	final MetaLogger
	    cl = new MetaLogger().setPrefix("cl: "),
	    a = new MetaLogger().setPrefix("a: "),
	    b = new MetaLogger().setPrefix("b: ");
	Guarana.reconfigure(ReconfigureBase.class, null, cl);
	final Reconfigure o = new Reconfigure();
	Guarana.reconfigure(o, null, a);
	Guarana.reconfigure(o, null, b);
	Guarana.reconfigure(o, b, a);
	Guarana.reconfigure(o, b, a);
	Guarana.reconfigure(o, null, null);
	Guarana.reconfigure(o, a, b);
    }
}
