/* RendTributacaoExclusiva - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.rendTributacaoExclusiva;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class RendTributacaoExclusiva extends ObjetoNegocio
{
  private Valor decimoTerceiro = new Valor (); // 01
  private Valor ganhosCapital = new Valor (); // 02
  private Valor ganhosCapitalEstrangeira = new Valor (); // 03
  private Valor ganhosCapitalEmEspecie = new Valor (); // 04
  private Valor ganhosRendaVariavel = new Valor (); // 05
  private ColecaoItemQuadroOutrosRendimentos rendAplicacoesQuadroAuxiliar; // 06
  private Valor RRA = new Valor (); // 07
  private Valor decimoTerceiroDependentes = new Valor (); // 08
  private Valor RRADep = new Valor (); // 09
  private ColecaoItemQuadroOutrosRendimentos jurosCapitalProprioQuadroAuxiliar; // 10
  private ColecaoItemQuadroOutrosRendimentos rendPLRQuadroAuxiliar; // 11
  private ColecaoItemQuadroOutrosRendimentos outrosQuadroAuxiliar; // 12
  private Valor total = new Valor ();
  
  public RendTributacaoExclusiva (final DeclaracaoIRPF objDecl)
  {
    rendAplicacoesQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Rendimentos de Aplicações Financeiras");
    jurosCapitalProprioQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Juros sobre capital próprio");
    rendPLRQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Participação nos lucros e resultados");
    outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Outros rendimentos de tributação exclusiva na fonte");
    getDecimoTerceiro ().setReadOnly (true);
    getGanhosCapital ().setReadOnly (true);
    getGanhosCapitalEstrangeira ().setReadOnly (true);
    getGanhosCapitalEmEspecie ().setReadOnly (true);
    getGanhosRendaVariavel ().setReadOnly (true);
    getDecimoTerceiroDependentes ().setReadOnly (true);
    getRRA ().setReadOnly (true);
    getRRADep ().setReadOnly (true);
    getTotal ().setReadOnly (true);
  }
  
  public void addObservador (Observador obs)
  {
    decimoTerceiro.addObservador (obs);
    ganhosCapital.addObservador (obs);
    ganhosCapitalEstrangeira.addObservador (obs);
    ganhosCapitalEmEspecie.addObservador (obs);
    ganhosRendaVariavel.addObservador (obs);
    rendAplicacoesQuadroAuxiliar.getTotais ().addObservador (obs);
    RRA.addObservador (obs);
    decimoTerceiroDependentes.addObservador (obs);
    RRADep.addObservador (obs);
    jurosCapitalProprioQuadroAuxiliar.getTotais ().addObservador (obs);
    rendPLRQuadroAuxiliar.getTotais ().addObservador (obs);
    outrosQuadroAuxiliar.getTotais ().addObservador (obs);
  }
  
  public Valor getDecimoTerceiro ()
  {
    return decimoTerceiro;
  }
  
  public Valor getGanhosCapital ()
  {
    return ganhosCapital;
  }
  
  public Valor getGanhosCapitalEmEspecie ()
  {
    return ganhosCapitalEmEspecie;
  }
  
  public Valor getGanhosCapitalEstrangeira ()
  {
    return ganhosCapitalEstrangeira;
  }
  
  public Valor getGanhosRendaVariavel ()
  {
    return ganhosRendaVariavel;
  }
  
  public ColecaoItemQuadroOutrosRendimentos getRendAplicacoesQuadroAuxiliar ()
  {
    return rendAplicacoesQuadroAuxiliar;
  }
  
  public Valor getRendAplicacoes ()
  {
    return getRendAplicacoesQuadroAuxiliar ().getTotais ();
  }
  
  public Valor getRRA ()
  {
    return RRA;
  }
  
  public Valor getDecimoTerceiroDependentes ()
  {
    return decimoTerceiroDependentes;
  }
  
  public Valor getRRADep ()
  {
    return RRADep;
  }
  
  public ColecaoItemQuadroOutrosRendimentos getJurosCapitalProprioQuadroAuxiliar ()
  {
    return jurosCapitalProprioQuadroAuxiliar;
  }
  
  public Valor getJurosCapitalProprio ()
  {
    return getJurosCapitalProprioQuadroAuxiliar ().getTotais ();
  }
  
  public ColecaoItemQuadroOutrosRendimentos getRendPLRQuadroAuxiliar ()
  {
    return rendPLRQuadroAuxiliar;
  }
  
  public Valor getRendPLR ()
  {
    return getRendPLRQuadroAuxiliar ().getTotais ();
  }
  
  public ColecaoItemQuadroOutrosRendimentos getOutrosQuadroAuxiliar ()
  {
    return outrosQuadroAuxiliar;
  }
  
  public Valor getOutros ()
  {
    return getOutrosQuadroAuxiliar ().getTotais ();
  }
  
  public Valor getTotal ()
  {
    return total;
  }
  
  public Valor recuperarExclusivosTitular ()
  {
    Valor result = new Valor ();
    result.append ('+', decimoTerceiro);
    result.append ('+', ganhosCapital);
    result.append ('+', ganhosCapitalEstrangeira);
    result.append ('+', ganhosCapitalEmEspecie);
    result.append ('+', ganhosRendaVariavel);
    result.append ('+', getRendAplicacoesQuadroAuxiliar ().getTotaisTitular ());
    result.append ('+', RRA);
    result.append ('+', getJurosCapitalProprioQuadroAuxiliar ().getTotaisTitular ());
    result.append ('+', getRendPLRQuadroAuxiliar ().getTotaisTitular ());
    result.append ('+', getOutrosQuadroAuxiliar ().getTotaisTitular ());
    return result;
  }
  
  public Valor recuperarExclusivosDependentes ()
  {
    Valor result = new Valor ();
    result.append ('+', getRendAplicacoesQuadroAuxiliar ().getTotaisDependentes ());
    result.append ('+', decimoTerceiroDependentes);
    result.append ('+', RRADep);
    result.append ('+', getJurosCapitalProprioQuadroAuxiliar ().getTotaisDependentes ());
    result.append ('+', getRendPLRQuadroAuxiliar ().getTotaisDependentes ());
    result.append ('+', getOutrosQuadroAuxiliar ().getTotaisDependentes ());
    return result;
  }
  
  public Valor recuperarTotalTitularExceto13_RV_e_GC ()
  {
    Valor result = new Valor ();
    result.append ('+', getRendAplicacoesQuadroAuxiliar ().getTotaisTitular ());
    result.append ('+', RRA);
    result.append ('+', getJurosCapitalProprioQuadroAuxiliar ().getTotaisTitular ());
    result.append ('+', getRendPLRQuadroAuxiliar ().getTotaisTitular ());
    result.append ('+', getOutrosQuadroAuxiliar ().getTotaisTitular ());
    return result;
  }
}
