/* ObservadorCodigoPagamento - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.pagamentos;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class ObservadorCodigoPagamento extends Observador
{
  private DeclaracaoIRPF declaracaoIRPF = null;
  
  public ObservadorCodigoPagamento (DeclaracaoIRPF dec)
  {
    declaracaoIRPF = dec;
  }
  
  public void notifica (Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo)
  {
    if (nomePropriedade != null)
      {
	if (nomePropriedade.equals ("ObjetoInserido"))
	  {
	    Pagamento pagamento = (Pagamento) valorNovo;
	    pagamento.getCodigo ().addObservador (this);
	    String tipoPagamento = pagamento.getTipo ().asString ();
	    pagamento.getDependenteOuAlimentando ().setHabilitado (tipoPagamento.equals (Pagamento.TIPO_DEPENDENTE) || tipoPagamento.equals (Pagamento.TIPO_ALIMENTANDO));
	    pagamento.getCodigo ().disparaObservadores ();
	  }
	else if (nomePropriedade.equals ("ObjetoRemovido"))
	  {
	    Pagamento pagamento = (Pagamento) valorNovo;
	    pagamento.getCodigo ().removeObservador (this);
	  }
	else if (nomePropriedade.equals ("C\u00f3digo") || nomePropriedade.equals ("Tipo"))
	  {
	    Pagamento pagamento = (Pagamento) ((Informacao) observado).getOwner ();
	    String codigoPagamento = pagamento.getCodigo ().getConteudoAtual (0);
	    if (pagamento.getTipo ().asString ().equals (Pagamento.TIPO_TITULAR))
	      {
		pagamento.getDependenteOuAlimentando ().setHabilitado (false);
		pagamento.getDependenteOuAlimentando ().clear ();
	      }
	    else
	      pagamento.getDependenteOuAlimentando ().setHabilitado (true);
	    if (codigoPagamento.equals (Pagamento.PAGAMENTO_PREVIPRIVADA) || codigoPagamento.equals (Pagamento.PAGAMENTO_FAPI) || codigoPagamento.equals (Pagamento.PAGAMENTO_ADVOGADOS) || codigoPagamento.equals (Pagamento.PAGAMENTO_ADVOGADOS_TRAB) || codigoPagamento.equals (Pagamento.PAGAMENTO_ADVOGADOS_HONORARIOS) || codigoPagamento.equals (Pagamento.PAGAMENTO_PROFLIBERAL) || codigoPagamento.equals (Pagamento.PAGAMENTO_ALUGUEIS) || codigoPagamento.equals (Pagamento.PAGAMENTO_ADMINISTRADOR_IMOVEL) || codigoPagamento.equals (Pagamento.PAGAMENTO_CORRETOR_IMOVEL) || codigoPagamento.equals (Pagamento.PAGAMENTO_ARRENDRURAL) || codigoPagamento.equals (Pagamento.PAGAMENTO_OUTROS))
	      {
		pagamento.getParcelaNaoDedutivel ().setHabilitado (false);
		pagamento.getParcelaNaoDedutivel ().clear ();
		pagamento.getNiBeneficiario ().setHabilitado (true);
	      }
	    else
	      {
		pagamento.getParcelaNaoDedutivel ().setHabilitado (true);
		pagamento.getNiBeneficiario ().setHabilitado (true);
	      }
	  }
      }
  }
}
