/*
 * ============================================================================
 * GNU Lesser General Public License
 * ============================================================================
 *
 * JasperReports - Free Java report-generating library.
 * Copyright (C) 2001-2006 JasperSoft Corporation http://www.jaspersoft.com
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 * 
 * JasperSoft Corporation
 * 303 Second Street, Suite 450 North
 * San Francisco, CA 94107
 * http://www.jaspersoft.com
 */
package net.sf.jasperreports.charts;

import net.sf.jasperreports.engine.JRFont;

import java.awt.Color;


/**
 * Represents the formatting option for the textual
 * representation of a value displayed in a Meter or
 * Thermometer chart.
 * 
 * @author Barry Klawans (bklawans@users.sourceforge.net)
 * @version $Id: JRValueDisplay.java 1385 2006-09-06 00:29:03 +0300 (Wed, 06 Sep 2006) bklawans $
 */
public interface JRValueDisplay
{
	/**
	 * Returns the color to use when writing the value.
	 * 
	 * @return the color to use when writing the value
	 */
    public Color getColor();
    
    /**
     * Returns the formatting mask to use when writing the value.
     * The mask will be specified using the patterns defined
     * in <code>java.text.DecimalFormat</code>.
     * 
     * @return the formatting mask to use when writing the value
     */
    public String getMask();
    
    /**
     * Returns the font to use when writing the value.
     * 
     * @return the font to use when writing the value
     */
    public JRFont getFont();
}
